/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.solr.test;

import com.browseengine.solr.BoboRequestBuilder;
import java.util.List;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;

public class SolrBoboTest {
    public static void main(String[] args) throws Exception {
        String url = "http://localhost:8983/solr";
        CommonsHttpSolrServer solrSvr = new CommonsHttpSolrServer(url);
        SolrQuery query = new SolrQuery();
        query.setQuery("van");
        query.setFacet(true);
        query.addFacetField(new String[]{"color", "category"});
        query.setFacetMinCount(1);
        query.setFields(new String[]{"color,score,category"});
        query.setStart(Integer.valueOf(0));
        query.setRows(Integer.valueOf(10));
        query.setFilterQueries(new String[]{"cool"});
        query.set("facet.query", new String[]{"color:red"});
        BoboRequestBuilder.applyFacetExpand(query, "color", true);
        QueryResponse res = solrSvr.query((SolrParams)query);
        SolrDocumentList results = res.getResults();
        long numFound = results.getNumFound();
        System.out.println("num hits: " + numFound);
        for (SolrDocument doc : results) {
            System.out.println(doc);
        }
        List facetFieldList = res.getFacetFields();
        for (FacetField ff : facetFieldList) {
            System.out.println(ff.getName() + ":");
            List vals = ff.getValues();
            if (vals == null) continue;
            for (FacetField.Count val : vals) {
                System.out.println(val.getName() + "(" + val.getCount() + ")");
            }
        }
    }
}

