/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import com.browseengine.bobo.geosearch.bo.GeoSearchConfig;
import com.browseengine.bobo.geosearch.index.impl.DeletePairedExtensionDirectory;
import com.browseengine.bobo.geosearch.merge.IGeoMerger;
import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.GeoIndexingChain;
import org.apache.lucene.index.GeoMergeInfo;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;

public class GeoIndexWriter
extends IndexWriter {
    GeoSearchConfig geoConfig;

    public GeoIndexWriter(Directory d, IndexWriterConfig indexWriterConfig, GeoSearchConfig geoConfig) throws CorruptIndexException, LockObtainFailedException, IOException {
        super(GeoIndexWriter.buildGeoDirectory(d, geoConfig), GeoIndexWriter.setIndexingChain(indexWriterConfig, geoConfig));
        this.geoConfig = geoConfig;
    }

    public static Directory buildGeoDirectory(Directory dir, GeoSearchConfig geoConfig) {
        DeletePairedExtensionDirectory pairedDirectory = new DeletePairedExtensionDirectory(dir);
        for (String pairedExtension : geoConfig.getPairedExtensionsForDelete()) {
            pairedDirectory.addExtensionPairing(pairedExtension, geoConfig.getGeoFileExtension());
        }
        return pairedDirectory;
    }

    public static IndexWriterConfig setIndexingChain(IndexWriterConfig indexWriterConfig, GeoSearchConfig geoConfig) {
        return indexWriterConfig.setIndexingChain((DocumentsWriter.IndexingChain)new GeoIndexingChain(geoConfig, indexWriterConfig.getIndexingChain()));
    }

    @Override
    public void beforeMergeAfterSetup(MergePolicy.OneMerge merge) throws IOException {
        merge.checkAborted(this.getDirectory());
        GeoMergeInfo geoMergeInfo = new GeoMergeInfo(merge, this.getDirectory());
        IGeoMerger geoMerger = this.geoConfig.getGeoMerger();
        geoMerger.merge(geoMergeInfo, this.geoConfig);
    }
}

