/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import com.browseengine.bobo.geosearch.index.IGeoIndexer;
import com.browseengine.bobo.geosearch.index.bo.GeoCoordinateField;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.DocConsumerPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterThreadState;

public class GeoDocConsumerPerThread
extends DocConsumerPerThread {
    DocConsumerPerThread defaultDocConsumerPerThread;
    DocumentsWriter.DocState docState;
    IGeoIndexer geoIndexer;

    public GeoDocConsumerPerThread(DocConsumerPerThread defaultDocConsumerPerThread, DocumentsWriterThreadState threadState, IGeoIndexer geoIndexer) {
        this.defaultDocConsumerPerThread = defaultDocConsumerPerThread;
        this.docState = threadState.docState;
        this.geoIndexer = geoIndexer;
    }

    DocumentsWriter.DocWriter processDocument() throws IOException {
        Document doc = this.docState.doc;
        int docID = this.docState.docID;
        List fields = doc.getFields();
        Vector<GeoCoordinateField> geoFields = new Vector<GeoCoordinateField>();
        for (Fieldable field : fields) {
            if (!(field instanceof GeoCoordinateField)) continue;
            geoFields.add((GeoCoordinateField)field);
        }
        for (GeoCoordinateField geoField : geoFields) {
            this.geoIndexer.index(docID, geoField);
            doc.removeFields(geoField.name());
        }
        return this.defaultDocConsumerPerThread.processDocument();
    }

    void abort() {
        this.defaultDocConsumerPerThread.abort();
        this.geoIndexer.abort();
    }

    public DocConsumerPerThread getDefaultDocConsumerPerThread() {
        return this.defaultDocConsumerPerThread;
    }
}

