/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import com.browseengine.bobo.geosearch.bo.GeoSearchConfig;
import com.browseengine.bobo.geosearch.index.IGeoIndexer;
import com.browseengine.bobo.geosearch.index.impl.GeoIndexer;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.lucene.index.DocConsumer;
import org.apache.lucene.index.DocConsumerPerThread;
import org.apache.lucene.index.DocumentsWriterThreadState;
import org.apache.lucene.index.GeoDocConsumerPerThread;
import org.apache.lucene.index.SegmentWriteState;

public class GeoDocConsumer
extends DocConsumer {
    DocConsumer defaultDocConsumer;
    IGeoIndexer geoIndexer;

    public GeoDocConsumer(GeoSearchConfig config, DocConsumer defaultDocConsumer) {
        this.defaultDocConsumer = defaultDocConsumer;
        this.geoIndexer = new GeoIndexer(config);
    }

    public void setGeoIndexer(IGeoIndexer geoIndexer) {
        this.geoIndexer = geoIndexer;
    }

    DocConsumerPerThread addThread(DocumentsWriterThreadState perThread) throws IOException {
        DocConsumerPerThread defaultDocConsumerPerThread = this.defaultDocConsumer.addThread(perThread);
        return new GeoDocConsumerPerThread(defaultDocConsumerPerThread, perThread, this.geoIndexer);
    }

    void flush(Collection<DocConsumerPerThread> threads, SegmentWriteState state) throws IOException {
        HashSet<DocConsumerPerThread> defaultDocConsumerThreads = new HashSet<DocConsumerPerThread>(threads.size());
        for (DocConsumerPerThread thread : threads) {
            if (thread instanceof GeoDocConsumerPerThread) {
                GeoDocConsumerPerThread geoThread = (GeoDocConsumerPerThread)thread;
                defaultDocConsumerThreads.add(geoThread.getDefaultDocConsumerPerThread());
                continue;
            }
            defaultDocConsumerThreads.add(thread);
        }
        this.defaultDocConsumer.flush(defaultDocConsumerThreads, state);
        this.geoIndexer.flush(state.directory, state.segmentName);
    }

    void abort() {
        this.defaultDocConsumer.abort();
        this.geoIndexer.abort();
    }

    boolean freeRAM() {
        return this.defaultDocConsumer.freeRAM();
    }

    public DocConsumer getDefaultDocConsumer() {
        return this.defaultDocConsumer;
    }
}

