/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.solo.index.impl;

import com.browseengine.bobo.geosearch.IFieldNameFilterConverter;
import com.browseengine.bobo.geosearch.IGeoConverter;
import com.browseengine.bobo.geosearch.bo.GeoSearchConfig;
import com.browseengine.bobo.geosearch.bo.GeoSegmentInfo;
import com.browseengine.bobo.geosearch.index.bo.GeoCoordinate;
import com.browseengine.bobo.geosearch.index.bo.GeoCoordinateField;
import com.browseengine.bobo.geosearch.index.impl.GeoSegmentReader;
import com.browseengine.bobo.geosearch.index.impl.GeoSegmentWriter;
import com.browseengine.bobo.geosearch.solo.bo.IDGeoRecord;
import com.browseengine.bobo.geosearch.solo.bo.IndexTooLargeException;
import com.browseengine.bobo.geosearch.solo.impl.IDGeoRecordComparator;
import com.browseengine.bobo.geosearch.solo.impl.IDGeoRecordSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;

public class GeoOnlyIndexer {
    GeoSearchConfig config;
    Directory directory;
    String indexName;
    Lock lock;
    IDGeoRecordComparator geoComparator = new IDGeoRecordComparator();
    IDGeoRecordSerializer geoRecordSerializer = new IDGeoRecordSerializer();
    TreeSet<IDGeoRecord> inMemoryIndex = new TreeSet<IDGeoRecord>(new IDGeoRecordComparator());
    List<IDGeoRecord> newRecords = new LinkedList<IDGeoRecord>();
    Set<byte[]> removedRecords = new HashSet<byte[]>();

    public GeoOnlyIndexer(GeoSearchConfig config, Directory directory, String indexName) throws IOException {
        this.config = config;
        this.directory = directory;
        this.indexName = indexName;
        this.lock = directory.makeLock(indexName);
        if (!this.lock.obtain()) {
            throw new LockObtainFailedException("Index locked for write: " + indexName);
        }
    }

    public void index(byte[] uuid, GeoCoordinateField field) {
        if (uuid.length != this.config.getBytesForId()) {
            throw new IllegalArgumentException("invalid uuid length: " + uuid.length + ".  Expected uuid to be of length " + this.config.getBytesForId() + ".");
        }
        IGeoConverter converter = this.config.getGeoConverter();
        GeoCoordinate geoCoordinate = field.getGeoCoordinate();
        IDGeoRecord geoRecord = converter.toIDGeoRecord(geoCoordinate.getLatitude(), geoCoordinate.getLongitude(), uuid);
        this.newRecords.add(geoRecord);
    }

    public void delete(byte[] uuid) {
        this.removedRecords.add(uuid);
    }

    public void flush() throws IOException, IndexTooLargeException {
        this.loadCurrentIndex();
        for (IDGeoRecord newRecord : this.newRecords) {
            this.inMemoryIndex.add(newRecord);
        }
        if (this.inMemoryIndex.size() > this.config.getMaxIndexSize()) {
            throw new IndexTooLargeException(this.indexName, this.inMemoryIndex.size(), this.config.getMaxIndexSize());
        }
        this.flushInMemoryIndex();
    }

    public void close() throws IOException {
        this.lock.release();
    }

    private void flushInMemoryIndex() throws IOException {
        GeoSegmentWriter<IDGeoRecord> segmentWriter = this.getGeoSegmentWriter(this.inMemoryIndex);
        segmentWriter.close();
    }

    GeoSegmentWriter<IDGeoRecord> getGeoSegmentWriter(Set<IDGeoRecord> dataToFlush) throws IOException {
        String fileName = this.indexName + "." + this.config.getGeoFileExtension();
        return new GeoSegmentWriter<IDGeoRecord>(dataToFlush, this.directory, fileName, this.buildGeoSegmentInfo(this.indexName), this.geoRecordSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCurrentIndex() throws IOException {
        this.inMemoryIndex.clear();
        String fileName = this.indexName + "." + this.config.getGeoFileExtension();
        if (this.directory.fileExists(fileName)) {
            GeoSegmentReader<IDGeoRecord> currentIndex = this.getGeoSegmentReader();
            try {
                Iterator<IDGeoRecord> currentIndexIterator = currentIndex.getIterator(IDGeoRecord.MIN_VALID_GEORECORD, IDGeoRecord.MAX_VALID_GEORECORD);
                while (currentIndexIterator.hasNext()) {
                    IDGeoRecord geoRecord = currentIndexIterator.next();
                    if (this.isDeleted(geoRecord.id)) continue;
                    this.inMemoryIndex.add(geoRecord);
                }
            }
            finally {
                currentIndex.close();
            }
        }
    }

    private boolean isDeleted(byte[] uuid) {
        for (byte[] deletedUUID : this.removedRecords) {
            if (!Arrays.equals(uuid, deletedUUID)) continue;
            return true;
        }
        return false;
    }

    GeoSegmentReader<IDGeoRecord> getGeoSegmentReader() throws IOException {
        String fileName = this.indexName + "." + this.config.getGeoFileExtension();
        return new GeoSegmentReader<IDGeoRecord>(this.directory, fileName, -1, this.config.getBufferSizePerGeoSegmentReader(), this.geoRecordSerializer, this.geoComparator);
    }

    private GeoSegmentInfo buildGeoSegmentInfo(String segmentName) throws IOException {
        IGeoConverter converter = this.config.getGeoConverter();
        GeoSegmentInfo info = new GeoSegmentInfo();
        info.setGeoVersion(1);
        info.setSegmentName(segmentName);
        info.setBytesPerRecord(12 + this.config.getBytesForId());
        IFieldNameFilterConverter fieldNameFilterConverter = converter.makeFieldNameFilterConverter();
        if (fieldNameFilterConverter != null) {
            info.setFieldNameFilterConverter(fieldNameFilterConverter);
        }
        return info;
    }
}

