/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.solo.impl;

import com.browseengine.bobo.geosearch.IGeoRecordSerializer;
import com.browseengine.bobo.geosearch.solo.bo.IDGeoRecord;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class IDGeoRecordSerializer
implements IGeoRecordSerializer<IDGeoRecord> {
    public static final int INTERLACE_BYTES = 12;

    @Override
    public void writeGeoRecord(IndexOutput output, IDGeoRecord record, int recordByteCount) throws IOException {
        if (record.id.length != recordByteCount - 12) {
            throw new IllegalArgumentException("Incorrect number of id bytes given.  This is most likely a bug!  ExpectedBytes=" + (recordByteCount - 12) + "; receivedBytes=" + record.id.length);
        }
        output.writeLong(record.highOrder);
        output.writeInt(record.lowOrder);
        output.writeBytes(record.id, record.id.length);
    }

    @Override
    public IDGeoRecord readGeoRecord(IndexInput input, int recordByteCount) throws IOException {
        long highOrder = input.readLong();
        int lowOrder = input.readInt();
        int countIdBytes = recordByteCount - 12;
        byte[] id = new byte[countIdBytes];
        input.readBytes(id, 0, countIdBytes, false);
        return new IDGeoRecord(highOrder, lowOrder, id);
    }
}

