/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.solo.bo;

import com.browseengine.bobo.geosearch.bo.IGeoRecord;
import java.util.Arrays;

public class IDGeoRecord
implements IGeoRecord {
    public final long highOrder;
    public final int lowOrder;
    public final byte[] id;
    public static final IDGeoRecord MIN_VALID_GEORECORD = new IDGeoRecord(0L, 0, new byte[0]);
    public static final IDGeoRecord MAX_VALID_GEORECORD = new IDGeoRecord(Long.MAX_VALUE, Integer.MAX_VALUE, new byte[0]);

    public IDGeoRecord(long highOrder, int lowOrder, byte[] id) {
        if (highOrder < 0L || lowOrder < 0) {
            throw new RuntimeException("GeoRecord(" + highOrder + ", " + lowOrder + ", " + id + "): only supports positive highOrder and lowOrder");
        }
        this.highOrder = highOrder;
        this.lowOrder = lowOrder;
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.highOrder ^ this.highOrder >>> 32);
        result = 31 * result + Arrays.hashCode(this.id);
        result = 31 * result + this.lowOrder;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IDGeoRecord other = (IDGeoRecord)obj;
        if (this.highOrder != other.highOrder) {
            return false;
        }
        if (!Arrays.equals(this.id, other.id)) {
            return false;
        }
        if (this.lowOrder != other.lowOrder) {
            return false;
        }
        return Arrays.equals(this.id, other.id);
    }

    public String toString() {
        return "GeoRecord [highOrder=" + this.highOrder + ", lowOrder=" + this.lowOrder + ", id=" + Arrays.toString(this.id) + "]";
    }
}

