/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.score.impl;

public class HaversineFormula {
    private static final double R = 3956.0;

    public static float computeHaversineDistanceMiles(double lon1, double lat1, double lon2, double lat2) {
        double dLon = lon2 - lon1;
        double dLat = lat2 - lat1;
        double sinLat = Math.sin(dLat / 2.0);
        double sinLon = Math.sin(dLon / 2.0);
        double a = sinLat * sinLat + Math.cos(lat1) * Math.cos(lat2) * sinLon * sinLon;
        double c = 2.0 * Math.asin(Math.min(1.0, Math.sqrt(a)));
        double d = 3956.0 * c;
        return (float)d;
    }

    public static double computeLatBoundary(float radius_d) {
        return (double)radius_d / 3956.0;
    }

    public static double computeLonBoundary(double lat1, float radius_d) {
        double dlon = 2.0 * Math.asin(Math.abs(Math.sin((double)radius_d / 7912.0) / Math.cos(lat1)));
        if (dlon < 0.0) {
            dlon += Math.PI;
        }
        return dlon;
    }
}

