/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.query;

import com.browseengine.bobo.geosearch.bo.GeoRecord;
import com.browseengine.bobo.geosearch.impl.IndexReaderDeletedDocs;
import com.browseengine.bobo.geosearch.index.impl.GeoIndexReader;
import com.browseengine.bobo.geosearch.index.impl.GeoSegmentReader;
import com.browseengine.bobo.geosearch.query.GeoQuery;
import com.browseengine.bobo.geosearch.query.GeoScorer;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class GeoWeight
extends Weight {
    private static final long serialVersionUID = 1L;
    private final GeoQuery geoQuery;
    private float queryWeight;
    private float queryNorm;
    private float value;

    public GeoWeight(GeoQuery geoQuery) {
        this.geoQuery = geoQuery;
    }

    public Explanation explain(IndexReader reader, int doc) throws IOException {
        return new Explanation((float)doc, this.geoQuery.toString() + ", queryNorm: " + this.queryNorm);
    }

    public Query getQuery() {
        return this.geoQuery;
    }

    public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
        if (!(reader instanceof GeoIndexReader)) {
            throw new RuntimeException("attempt to create a " + GeoScorer.class + " with a reader that was not a " + GeoIndexReader.class);
        }
        GeoIndexReader geoIndexReader = (GeoIndexReader)reader;
        List<GeoSegmentReader<GeoRecord>> segmentsInOrder = geoIndexReader.getGeoSegmentReaders();
        IndexReaderDeletedDocs wholeIndexDeletedDocs = new IndexReaderDeletedDocs(reader);
        double centroidLongitudeDegrees = this.geoQuery.getCentroidLongitude();
        double centroidLatitudeDegrees = this.geoQuery.getCentroidLatitude();
        float rangeInMiles = this.geoQuery.getRangeInMiles();
        return new GeoScorer(this, segmentsInOrder, wholeIndexDeletedDocs, centroidLongitudeDegrees, centroidLatitudeDegrees, rangeInMiles);
    }

    public float getValue() {
        return this.value;
    }

    public void normalize(float queryNorm) {
        this.queryNorm = queryNorm;
        this.queryWeight *= queryNorm;
        this.value = this.queryWeight;
    }

    public float sumOfSquaredWeights() throws IOException {
        this.queryWeight = this.geoQuery.getBoost();
        return this.queryWeight * this.queryWeight;
    }
}

