/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.query;

import com.browseengine.bobo.geosearch.IDeletedDocs;
import com.browseengine.bobo.geosearch.IGeoBlockOfHitsProvider;
import com.browseengine.bobo.geosearch.IGeoConverter;
import com.browseengine.bobo.geosearch.bo.DocsSortedByDocId;
import com.browseengine.bobo.geosearch.bo.GeoRecord;
import com.browseengine.bobo.geosearch.bo.GeoRecordAndLongitudeLatitudeDocId;
import com.browseengine.bobo.geosearch.impl.DeletedDocs;
import com.browseengine.bobo.geosearch.impl.GeoBlockOfHitsProvider;
import com.browseengine.bobo.geosearch.impl.GeoConverter;
import com.browseengine.bobo.geosearch.index.impl.GeoSegmentReader;
import com.browseengine.bobo.geosearch.score.IComputeDistance;
import com.browseengine.bobo.geosearch.score.impl.HaversineComputeDistance;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class GeoScorer
extends Scorer {
    private static final int BLOCK_SIZE = 16384;
    private static final int DOCID_CURSOR_NONE_YET = -1;
    private final IGeoConverter geoConverter = new GeoConverter();
    private final IGeoBlockOfHitsProvider geoBlockOfHitsProvider = new GeoBlockOfHitsProvider(this.geoConverter);
    private final IComputeDistance computeDistance;
    private final List<GeoSegmentReader<GeoRecord>> segmentsInOrder;
    private final double centroidLongitudeDegrees;
    private final double centroidLatitudeDegrees;
    private final float rangeInMiles;
    private double minimumLongitudeDegrees;
    private double maximumLongitudeDegrees;
    private double minimumLatitudeDegrees;
    private double maximumLatitudeDegrees;
    private int docid = -1;
    private int indexOfCurrentPartition = -1;
    private int startDocidOfCurrentPartition;
    private GeoSegmentReader<GeoRecord> currentSegment = null;
    private DocsSortedByDocId currentBlockScoredDocs;
    private Map.Entry<Integer, Collection<GeoRecordAndLongitudeLatitudeDocId>> currentDoc;
    private IDeletedDocs wholeIndexDeletedDocs;
    private static final float MINIMUM_DISTANCE_WE_CARE_ABOUT_MILES = 1.0E-4f;
    private int currentBlockGlobalMaxDoc = -1;

    public static void main(String[] args) {
        System.out.println("NO_MORE_DOCS equals to = 2147483647");
    }

    public GeoScorer(Weight weight, List<GeoSegmentReader<GeoRecord>> segmentsInOrder, IDeletedDocs wholeIndexDeletedDocs, double centroidLongitudeDegrees, double centroidLatitudeDegrees, float rangeInMiles) {
        super(weight);
        this.segmentsInOrder = segmentsInOrder;
        this.centroidLongitudeDegrees = centroidLongitudeDegrees;
        this.centroidLatitudeDegrees = centroidLatitudeDegrees;
        this.rangeInMiles = rangeInMiles;
        this.startDocidOfCurrentPartition = -1;
        this.computeDistance = new HaversineComputeDistance();
        this.init();
    }

    private void init() {
        double deltaLongitudeDegrees = this.computeDistance.computeLonBoundary(this.centroidLatitudeDegrees, this.rangeInMiles);
        double deltaLatitudeDegrees = this.computeDistance.computeLatBoundary(this.rangeInMiles);
        this.minimumLongitudeDegrees = this.centroidLongitudeDegrees - deltaLongitudeDegrees;
        this.maximumLongitudeDegrees = this.centroidLongitudeDegrees + deltaLongitudeDegrees;
        this.minimumLatitudeDegrees = this.centroidLatitudeDegrees - deltaLatitudeDegrees;
        this.maximumLatitudeDegrees = this.centroidLatitudeDegrees + deltaLatitudeDegrees;
    }

    public float score() throws IOException {
        assert (this.docid >= 0 && this.docid != Integer.MAX_VALUE);
        return this.score(this.currentDoc.getValue());
    }

    private float score(Collection<GeoRecordAndLongitudeLatitudeDocId> values) {
        float minimumDistanceMiles = 9999999.0f;
        for (GeoRecordAndLongitudeLatitudeDocId value : values) {
            float distanceMiles = this.computeDistance.getDistanceInMiles(this.centroidLongitudeDegrees, this.centroidLatitudeDegrees, value.longitudeLatitudeDocId.longitude, value.longitudeLatitudeDocId.latitude);
            if (!(distanceMiles < minimumDistanceMiles)) continue;
            minimumDistanceMiles = distanceMiles;
        }
        return this.score(minimumDistanceMiles);
    }

    private float score(float minimumDistanceMiles) {
        if (minimumDistanceMiles < 1.0E-4f) {
            return 1.0f;
        }
        return 1.0E-4f / minimumDistanceMiles;
    }

    public int advance(int target) throws IOException {
        assert (Integer.MAX_VALUE == this.docid || -1 == this.docid || target >= this.docid);
        this.fillBlockContainingAndSeekTo(target);
        return this.docid;
    }

    private boolean doesCurrentTreeContain(int seekDocid) {
        if (this.currentSegment == null) {
            return false;
        }
        int maxDocAbsoluteCurrentPartition = this.startDocidOfCurrentPartition + this.currentSegment.getMaxDoc();
        return seekDocid < maxDocAbsoluteCurrentPartition;
    }

    private void seekToTree(int seekDocid) {
        while (!this.doesCurrentTreeContain(seekDocid)) {
            if (this.indexOfCurrentPartition == Integer.MAX_VALUE) {
                return;
            }
            if (this.indexOfCurrentPartition == -1 && this.segmentsInOrder.size() > 0) {
                ++this.indexOfCurrentPartition;
                this.startDocidOfCurrentPartition = 0;
            } else {
                ++this.indexOfCurrentPartition;
                if (this.indexOfCurrentPartition < this.segmentsInOrder.size()) {
                    this.startDocidOfCurrentPartition += this.segmentsInOrder.get(this.indexOfCurrentPartition - 1).getMaxDoc();
                } else {
                    this.indexOfCurrentPartition = Integer.MAX_VALUE;
                    this.startDocidOfCurrentPartition = Integer.MAX_VALUE;
                    this.docid = Integer.MAX_VALUE;
                    return;
                }
            }
            this.currentSegment = this.segmentsInOrder.get(this.indexOfCurrentPartition);
        }
    }

    private boolean isBlockInMemoryAlreadyAndSeekWithinBlock(int seekDocid) {
        if (-1 == this.currentBlockGlobalMaxDoc) {
            return false;
        }
        if (seekDocid < this.currentBlockGlobalMaxDoc) {
            while (this.currentBlockScoredDocs.size() > 0 && this.docid < seekDocid && seekDocid < this.currentBlockGlobalMaxDoc) {
                this.nextDocidAndCurrentDocFromBlockInMemory();
            }
            if (seekDocid <= this.docid) {
                return true;
            }
        }
        return false;
    }

    private void nextDocidAndCurrentDocFromBlockInMemory() {
        Map.Entry<Integer, Collection<GeoRecordAndLongitudeLatitudeDocId>> doc = this.currentBlockScoredDocs.pollFirst();
        this.docid = doc.getKey() + this.startDocidOfCurrentPartition;
        this.currentDoc = doc;
    }

    private void fillBlockContainingAndSeekTo(int seekDocid) throws IOException {
        if (this.isBlockInMemoryAlreadyAndSeekWithinBlock(seekDocid)) {
            return;
        }
        if (-1 != this.currentBlockGlobalMaxDoc && Integer.MAX_VALUE != this.currentBlockGlobalMaxDoc) {
            seekDocid = Math.max(this.currentBlockGlobalMaxDoc, seekDocid);
        }
        this.seekToTree(seekDocid);
        if (Integer.MAX_VALUE == this.docid) {
            return;
        }
        this.pullBlockInMemory(seekDocid);
        if (this.currentBlockScoredDocs.size() == 0) {
            this.fillBlockContainingAndSeekTo(this.currentBlockGlobalMaxDoc);
        } else {
            if (Integer.MAX_VALUE == this.docid) {
                return;
            }
            this.nextDocidAndCurrentDocFromBlockInMemory();
        }
    }

    private void pullBlockInMemory(int seekDocid) throws IOException {
        int offsetDocidWithinPartition = seekDocid - this.startDocidOfCurrentPartition;
        DeletedDocs deletedDocsWithinSegment = new DeletedDocs(this.wholeIndexDeletedDocs, this.startDocidOfCurrentPartition);
        int blockNumber = offsetDocidWithinPartition / 16384;
        int minimumDocidInPartition = offsetDocidWithinPartition - blockNumber * 16384;
        int maxDocInPartition = this.currentSegment.getMaxDoc();
        int maximumDocidInPartition = Math.min(maxDocInPartition, (blockNumber + 1) * 16384);
        this.currentBlockScoredDocs = this.geoBlockOfHitsProvider.getBlock(this.currentSegment, deletedDocsWithinSegment, this.minimumLongitudeDegrees, this.minimumLatitudeDegrees, minimumDocidInPartition, this.maximumLongitudeDegrees, this.maximumLatitudeDegrees, maximumDocidInPartition);
        this.currentBlockGlobalMaxDoc = this.startDocidOfCurrentPartition + maximumDocidInPartition;
    }

    public int docID() {
        assert (this.docid >= 0);
        return this.docid;
    }

    public int nextDoc() throws IOException {
        if (this.docid == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.fillBlockContainingAndSeekTo(this.docid + 1);
        return this.docid;
    }
}

