/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.query;

import com.browseengine.bobo.geosearch.impl.GeoUtil;
import com.browseengine.bobo.geosearch.query.GeoWeight;
import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

public class GeoQuery
extends Query {
    private static final long serialVersionUID = 1L;
    double centroidLongitude;
    double centroidLatitude;
    float rangeInMiles;
    private static final float KM_TO_MILES = 0.62f;
    private static final float MINIMUM_RANGE_IN_MILES = 0.001f;
    private static final float MAXIMUM_RANGE_IN_MILES = 500.0f;

    public GeoQuery(double centroidLongitude, double centroidLatitude, Float rangeInMiles, Float rangeInKilometers) {
        this.centroidLongitude = centroidLongitude;
        this.centroidLatitude = centroidLatitude;
        if (!(null == rangeInMiles ^ null == rangeInKilometers)) {
            throw new RuntimeException("please specify either rangeInMiles or rangeInKilometers");
        }
        this.rangeInMiles = null != rangeInKilometers ? 0.62f * rangeInKilometers.floatValue() : rangeInMiles.floatValue();
        if (this.rangeInMiles < 0.001f || this.rangeInMiles > 500.0f) {
            throw new RuntimeException("rangeInMiles out of range [0.0010, 500.0]: " + this.rangeInMiles);
        }
        if (!GeoUtil.isValidLongitude(centroidLongitude) || !GeoUtil.isValidLatitude(centroidLatitude)) {
            throw new RuntimeException("bad centroidLongitude " + centroidLongitude + " or centroidLatitude " + centroidLatitude);
        }
    }

    public double getCentroidLongitude() {
        return this.centroidLongitude;
    }

    public double getCentroidLatitude() {
        return this.centroidLatitude;
    }

    public float getRangeInMiles() {
        return this.rangeInMiles;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new GeoWeight(this);
    }

    public String toString() {
        return "GeoQuery [centroidLatitude=" + this.centroidLatitude + ", centroidLongitude=" + this.centroidLongitude + ", rangeInMiles=" + this.rangeInMiles + "]";
    }

    public String toString(String arg0) {
        return this.toString();
    }
}

