/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.merge.impl;

import com.browseengine.bobo.geosearch.merge.impl.PeekingIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class OrderedIteratorChain<V>
implements Iterator<V> {
    private List<PeekingIterator<V>> listOfOrderedIterators;
    private Comparator<V> comparator;
    private int numberOfIterators;

    public OrderedIteratorChain(List<Iterator<V>> listOfOrderedIterators, Comparator<V> comparator) {
        this.numberOfIterators = listOfOrderedIterators.size();
        this.listOfOrderedIterators = new ArrayList<PeekingIterator<V>>(this.numberOfIterators);
        for (int i = 0; i < this.numberOfIterators; ++i) {
            this.listOfOrderedIterators.add(new PeekingIterator<V>(listOfOrderedIterators.get(i)));
        }
        this.comparator = comparator;
    }

    @Override
    public boolean hasNext() {
        for (int i = 0; i < this.numberOfIterators; ++i) {
            if (!this.listOfOrderedIterators.get(i).hasNext()) continue;
            return true;
        }
        return false;
    }

    private int findMinimumFromPeeks() {
        Object minimum = null;
        int nextCameFromIteratorAt = -1;
        for (int i = 0; i < this.numberOfIterators; ++i) {
            V candidate = this.listOfOrderedIterators.get(i).peek();
            if (null == candidate) continue;
            if (null == minimum) {
                minimum = candidate;
                nextCameFromIteratorAt = i;
                continue;
            }
            int comparison = this.comparator.compare(minimum, candidate);
            if (comparison <= 0) continue;
            minimum = candidate;
            nextCameFromIteratorAt = i;
        }
        return nextCameFromIteratorAt;
    }

    @Override
    public V next() {
        int minimumFromPeeks = this.findMinimumFromPeeks();
        if (minimumFromPeeks < 0) {
            throw new NoSuchElementException();
        }
        return this.listOfOrderedIterators.get(minimumFromPeeks).next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

