/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.merge.impl;

import com.browseengine.bobo.geosearch.IGeoConverter;
import com.browseengine.bobo.geosearch.bo.GeoRecord;
import com.browseengine.bobo.geosearch.bo.LatitudeLongitudeDocId;
import com.browseengine.bobo.geosearch.impl.BTree;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.apache.lucene.util.BitVector;

public class ConvertedGeoRecordIterator
implements Iterator<GeoRecord> {
    private static final Logger LOGGER = Logger.getLogger(ConvertedGeoRecordIterator.class);
    private final IGeoConverter geoConverter;
    private final int absoluteDocidOffset;
    private final BitVector deletedDocsThisPartition;
    private GeoRecord next;
    private final Iterator<GeoRecord> iteratorWithOriginalDocIds;

    public ConvertedGeoRecordIterator(IGeoConverter geoConverter, BTree<GeoRecord> geoRecords, int absoluteDocidOffset, BitVector deletedDocsThisPartition) throws IOException {
        this.absoluteDocidOffset = absoluteDocidOffset;
        this.geoConverter = geoConverter;
        this.deletedDocsThisPartition = deletedDocsThisPartition;
        this.iteratorWithOriginalDocIds = geoRecords.getIterator(GeoRecord.MIN_VALID_GEORECORD, GeoRecord.MAX_VALID_GEORECORD);
        this.advance();
    }

    private void printInOriginalRange(GeoRecord candidate, LatitudeLongitudeDocId raw) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("candidate in original range, geoRecord " + candidate + ", raw " + raw));
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private void advance() {
        if (!this.iteratorWithOriginalDocIds.hasNext()) {
            this.next = null;
            return;
        }
        GeoRecord geoRecordInNewRange = null;
        GeoRecord candidate = null;
        do {
            if (this.iteratorWithOriginalDocIds.hasNext()) {
                candidate = this.iteratorWithOriginalDocIds.next();
                if (null != candidate) {
                    LatitudeLongitudeDocId rawInOriginalDocId = this.geoConverter.toLongitudeLatitudeDocId(candidate);
                    if (this.deletedDocsThisPartition.get(rawInOriginalDocId.docid)) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("skipping deleted docid before merge for raw " + rawInOriginalDocId));
                        }
                    } else {
                        this.printInOriginalRange(candidate, rawInOriginalDocId);
                        geoRecordInNewRange = this.getGeoRecordInNewRange(candidate, rawInOriginalDocId);
                    }
                }
            } else {
                candidate = null;
            }
            if (null == candidate || null != geoRecordInNewRange) continue;
            String msg = "skipping candidate " + candidate + ", geoRecordInNewRange null";
            LOGGER.warn((Object)msg);
        } while (null != candidate && null == geoRecordInNewRange);
        this.next = null != geoRecordInNewRange ? geoRecordInNewRange : null;
    }

    private GeoRecord getGeoRecordInNewRange(GeoRecord candidate, LatitudeLongitudeDocId rawInOriginalDocId) {
        LatitudeLongitudeDocId merged = rawInOriginalDocId.clone();
        int mergedDocId = this.findDocIdInMergedIndex(this.absoluteDocidOffset, merged.docid, this.deletedDocsThisPartition);
        if (mergedDocId >= 0) {
            merged.docid = mergedDocId;
            return this.geoConverter.toGeoRecord(candidate.filterByte, merged);
        }
        return null;
    }

    @Override
    public GeoRecord next() {
        GeoRecord next = this.next;
        this.advance();
        if (null != next) {
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private int findDocIdInMergedIndex(int absoluteDocidOffset, int docIdInThisPartition, BitVector deletedDocsThisPartition) {
        if (0 == deletedDocsThisPartition.count()) {
            return absoluteDocidOffset + docIdInThisPartition;
        }
        if (deletedDocsThisPartition.get(docIdInThisPartition)) {
            return -1;
        }
        int countOfDeletedDocs = this.countDeletedDocs(docIdInThisPartition, deletedDocsThisPartition);
        return absoluteDocidOffset + docIdInThisPartition - countOfDeletedDocs;
    }

    private int countDeletedDocs(int toThisDocid, BitVector deletedDocsThisPartition) {
        int count = 0;
        for (int i = 0; i < toThisDocid; ++i) {
            if (!deletedDocsThisPartition.get(i)) continue;
            ++count;
        }
        return count;
    }
}

