/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.merge.impl;

import com.browseengine.bobo.geosearch.IGeoConverter;
import com.browseengine.bobo.geosearch.bo.GeoRecord;
import com.browseengine.bobo.geosearch.impl.BTree;
import com.browseengine.bobo.geosearch.impl.GeoRecordComparator;
import com.browseengine.bobo.geosearch.merge.impl.BufferedOrderedIterator;
import com.browseengine.bobo.geosearch.merge.impl.ConvertedGeoRecordIterator;
import com.browseengine.bobo.geosearch.merge.impl.OrderedIteratorChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.util.BitVector;

public class ChainedConvertedGeoRecordIterator
implements Iterator<GeoRecord> {
    private static final Logger LOGGER = Logger.getLogger(ChainedConvertedGeoRecordIterator.class);
    private static final GeoRecordComparator geoRecordCompareByBitMag = new GeoRecordComparator();
    protected IGeoConverter geoConverter;
    protected Iterator<GeoRecord> mergedIterator;
    protected OrderedIteratorChain<GeoRecord> orderedIteratorChain;

    public ChainedConvertedGeoRecordIterator(IGeoConverter geoConverter, List<BTree<GeoRecord>> partitions, List<BitVector> deletedDocsList, int totalBufferCapacity) throws IOException {
        this.geoConverter = geoConverter;
        int numberOfPartitions = partitions.size();
        if (numberOfPartitions != deletedDocsList.size()) {
            throw new RuntimeException("bad input, partitions.size() " + numberOfPartitions + ", deletedDocsList.size() " + deletedDocsList.size());
        }
        int docid = 0;
        int bufferCapacityPerIterator = totalBufferCapacity / numberOfPartitions;
        ArrayList mergedIterators = new ArrayList(partitions.size());
        for (int i = 0; i < partitions.size(); ++i) {
            BTree<GeoRecord> partition = partitions.get(i);
            BitVector deletedDocs = deletedDocsList.get(i);
            Iterator<GeoRecord> mergedIterator = new ConvertedGeoRecordIterator(geoConverter, partition, docid, deletedDocs);
            mergedIterator = new BufferedOrderedIterator<GeoRecord>(mergedIterator, geoRecordCompareByBitMag, bufferCapacityPerIterator);
            mergedIterators.add(mergedIterator);
            docid += deletedDocs.size() - deletedDocs.count();
        }
        this.orderedIteratorChain = new OrderedIteratorChain<GeoRecord>(mergedIterators, geoRecordCompareByBitMag);
    }

    @Override
    public boolean hasNext() {
        return this.orderedIteratorChain.hasNext();
    }

    @Override
    public GeoRecord next() {
        return this.orderedIteratorChain.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

