/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.merge.impl;

import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class BufferedOrderedIterator<V>
implements Iterator<V> {
    private Iterator<V> iterator;
    private Comparator<V> comparator;
    private int bufferCapacity;
    private TreeSet<V> buffer;
    private V prev;

    public BufferedOrderedIterator(Iterator<V> iterator, Comparator<V> comparator, int bufferCapacity) {
        this.iterator = iterator;
        this.comparator = comparator;
        this.bufferCapacity = bufferCapacity;
        this.buffer = new TreeSet<V>(comparator);
        this.fill();
    }

    private void fill() {
        while (this.iterator.hasNext() && this.buffer.size() < this.bufferCapacity) {
            V next = this.iterator.next();
            this.buffer.add(next);
        }
    }

    @Override
    public boolean hasNext() {
        this.fill();
        return this.buffer.size() > 0;
    }

    @Override
    public V next() {
        int comparison;
        this.fill();
        V current = this.buffer.pollFirst();
        if (null != this.prev && (comparison = this.comparator.compare(this.prev, current)) > 0) {
            throw new RuntimeException("out-of-order condition detected, prev " + this.prev + ", current " + current + ", comparison " + comparison);
        }
        this.prev = current;
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

