/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.merge.impl;

import com.browseengine.bobo.geosearch.IFieldNameFilterConverter;
import com.browseengine.bobo.geosearch.IGeoConverter;
import com.browseengine.bobo.geosearch.IGeoRecordSerializer;
import com.browseengine.bobo.geosearch.bo.GeoRecord;
import com.browseengine.bobo.geosearch.bo.GeoSearchConfig;
import com.browseengine.bobo.geosearch.bo.GeoSegmentInfo;
import com.browseengine.bobo.geosearch.impl.BTree;
import com.browseengine.bobo.geosearch.impl.GeoRecordComparator;
import com.browseengine.bobo.geosearch.impl.GeoRecordSerializer;
import com.browseengine.bobo.geosearch.index.impl.GeoSegmentReader;
import com.browseengine.bobo.geosearch.index.impl.GeoSegmentWriter;
import com.browseengine.bobo.geosearch.merge.IGeoMergeInfo;
import com.browseengine.bobo.geosearch.merge.IGeoMerger;
import com.browseengine.bobo.geosearch.merge.impl.ChainedConvertedGeoRecordIterator;
import com.browseengine.bobo.geosearch.merge.impl.ConvertedGeoRecordIterator;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.IOUtils;
import org.springframework.stereotype.Component;

@Component
public class BufferedGeoMerger
implements IGeoMerger {
    private static final Logger LOGGER = Logger.getLogger(BufferedGeoMerger.class);
    public static final int BUFFER_CAPACITY = 10000;
    private final IGeoRecordSerializer<GeoRecord> geoRecordSerializer = new GeoRecordSerializer();
    private final Comparator<GeoRecord> geoComparator = new GeoRecordComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(IGeoMergeInfo geoMergeInfo, GeoSearchConfig config) throws IOException {
        IGeoConverter geoConverter = config.getGeoConverter();
        int bufferSizePerGeoReader = config.getBufferSizePerGeoSegmentReader();
        Directory directory = geoMergeInfo.getDirectory();
        List<SegmentReader> readers = geoMergeInfo.getReaders();
        List<SegmentInfo> segments = geoMergeInfo.getSegmentsToMerge();
        ArrayList<BTree<GeoRecord>> mergeInputBTrees = new ArrayList<BTree<GeoRecord>>(segments.size());
        ArrayList<BitVector> deletedDocsList = new ArrayList<BitVector>(segments.size());
        boolean success = false;
        try {
            assert (readers.size() == segments.size());
            IFieldNameFilterConverter fieldNameFilterConverter = config.getGeoConverter().makeFieldNameFilterConverter();
            boolean hasFieldNameFilterConverter = false;
            for (SegmentReader reader : readers) {
                String geoFileName = config.getGeoFileName(reader.getSegmentName());
                BTree<GeoRecord> segmentBTree = this.getInputBTree(directory, geoFileName, bufferSizePerGeoReader);
                mergeInputBTrees.add(segmentBTree);
                BitVector deletedDocs = this.buildDeletedDocsForSegment(reader);
                deletedDocsList.add(deletedDocs);
                if (hasFieldNameFilterConverter) continue;
                hasFieldNameFilterConverter = this.loadFieldNameFilterConverter(directory, geoFileName, fieldNameFilterConverter);
            }
            if (!hasFieldNameFilterConverter) {
                LOGGER.warn((Object)"nothing to do during geo merge, no .geo files found for segments");
                success = true;
                return;
            }
            int newSegmentSize = this.calculateMergedSegmentSize(deletedDocsList, mergeInputBTrees, geoConverter);
            this.buildMergedSegment(mergeInputBTrees, deletedDocsList, newSegmentSize, geoMergeInfo, config, fieldNameFilterConverter);
            success = true;
        }
        finally {
            if (success) {
                IOUtils.close(mergeInputBTrees);
            } else {
                IOUtils.closeWhileHandlingException(mergeInputBTrees);
            }
        }
    }

    protected boolean loadFieldNameFilterConverter(Directory directory, String geoFileName, IFieldNameFilterConverter fieldNameFilterConverter) throws IOException {
        try {
            IndexInput input = directory.openInput(geoFileName);
            input.readVInt();
            input.readInt();
            input.readVInt();
            fieldNameFilterConverter.loadFromInput((DataInput)input);
            return true;
        }
        catch (FileNotFoundException e) {
            LOGGER.warn((Object)("suppressing missing geo file pair, treating as no field names: " + e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildMergedSegment(List<BTree<GeoRecord>> mergeInputBTrees, List<BitVector> deletedDocsList, int newSegmentSize, IGeoMergeInfo geoMergeInfo, GeoSearchConfig config, IFieldNameFilterConverter fieldNameFilterConverter) throws IOException {
        block5: {
            BTree<GeoRecord> mergeOutputBTree;
            block4: {
                Directory directory = geoMergeInfo.getDirectory();
                IGeoConverter geoConverter = config.getGeoConverter();
                String segmentName = geoMergeInfo.getNewSegment().name;
                String outputFileName = config.getGeoFileName(segmentName);
                GeoSegmentInfo geoSegmentInfo = this.buildGeoSegmentInfo(segmentName, fieldNameFilterConverter);
                ChainedConvertedGeoRecordIterator inputIterator = new ChainedConvertedGeoRecordIterator(geoConverter, mergeInputBTrees, deletedDocsList, 10000);
                mergeOutputBTree = null;
                boolean success = false;
                try {
                    mergeOutputBTree = this.getOutputBTree(newSegmentSize, inputIterator, directory, outputFileName, geoSegmentInfo);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{mergeOutputBTree});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{mergeOutputBTree});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{mergeOutputBTree});
                break block5;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{mergeOutputBTree});
        }
    }

    private GeoSegmentInfo buildGeoSegmentInfo(String segmentName, IFieldNameFilterConverter fieldNameFilterConverter) {
        GeoSegmentInfo geoSegmentInfo = new GeoSegmentInfo();
        geoSegmentInfo.setSegmentName(segmentName);
        geoSegmentInfo.setFieldNameFilterConverter(fieldNameFilterConverter);
        return geoSegmentInfo;
    }

    protected BTree<GeoRecord> getOutputBTree(int newSegmentSize, Iterator<GeoRecord> inputIterator, Directory directory, String outputFileName, GeoSegmentInfo geoSegmentInfo) throws IOException {
        return new GeoSegmentWriter<GeoRecord>(newSegmentSize, inputIterator, directory, outputFileName, geoSegmentInfo, this.geoRecordSerializer);
    }

    protected BTree<GeoRecord> getInputBTree(Directory directory, String geoFileName, int bufferSizePerGeoReader) throws IOException {
        return new GeoSegmentReader<GeoRecord>(directory, geoFileName, -1, bufferSizePerGeoReader, this.geoRecordSerializer, this.geoComparator);
    }

    private int calculateMergedSegmentSize(List<BitVector> deletedDocsList, List<BTree<GeoRecord>> mergeInputBTrees, IGeoConverter geoConverter) throws IOException {
        int newSegmentSize = 0;
        for (int i = 0; i < mergeInputBTrees.size(); ++i) {
            BTree<GeoRecord> mergeInputBTree = mergeInputBTrees.get(i);
            BitVector deletedDocs = deletedDocsList.get(i);
            newSegmentSize += this.calculateSegmentToMergeSize(mergeInputBTree, deletedDocs, geoConverter);
        }
        return newSegmentSize;
    }

    private int calculateSegmentToMergeSize(BTree<GeoRecord> mergeInputBTree, BitVector deletedDocs, IGeoConverter geoConverter) throws IOException {
        ConvertedGeoRecordIterator treeIter = new ConvertedGeoRecordIterator(geoConverter, mergeInputBTree, 0, deletedDocs);
        int numRecordsToMerge = 0;
        while (treeIter.hasNext()) {
            ++numRecordsToMerge;
            treeIter.next();
        }
        return numRecordsToMerge;
    }

    private BitVector buildDeletedDocsForSegment(SegmentReader reader) {
        BitVector deletedDocs = new BitVector(reader.maxDoc());
        for (int i = 0; i < deletedDocs.size(); ++i) {
            if (!reader.isDeleted(i)) continue;
            deletedDocs.set(i);
        }
        return deletedDocs;
    }
}

