/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.index.impl;

import com.browseengine.bobo.geosearch.IFieldNameFilterConverter;
import com.browseengine.bobo.geosearch.IGeoRecordSerializer;
import com.browseengine.bobo.geosearch.bo.GeoSegmentInfo;
import com.browseengine.bobo.geosearch.bo.IGeoRecord;
import com.browseengine.bobo.geosearch.impl.BTree;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;

public class GeoSegmentWriter<G extends IGeoRecord>
extends BTree<G>
implements Closeable {
    IGeoRecordSerializer<G> geoRecordSerializer;
    IndexOutput indexOutput;
    GeoSegmentInfo geoSegmentInfo;
    int maxIndex;
    int arrayLength;
    long treeDataStart;
    private static final int ZERO_BUFFER_SIZE = 4096;

    public GeoSegmentWriter(Set<G> tree, Directory directory, String fileName, GeoSegmentInfo geoSegmentInfo, IGeoRecordSerializer<G> geoRecordSerializer) throws IOException {
        super(tree.size(), false);
        this.arrayLength = tree.size();
        this.geoSegmentInfo = geoSegmentInfo;
        this.geoRecordSerializer = geoRecordSerializer;
        this.indexOutput = directory.createOutput(fileName);
        try {
            this.buildBTreeFromSet(tree);
        }
        catch (IOException e) {
            this.close();
        }
    }

    public GeoSegmentWriter(int treeSize, Iterator<G> inputIterator, Directory directory, String fileName, GeoSegmentInfo geoSegmentInfo, IGeoRecordSerializer<G> geoRecordSerializer) throws IOException {
        super(treeSize, false);
        this.arrayLength = treeSize;
        this.geoSegmentInfo = geoSegmentInfo;
        this.geoRecordSerializer = geoRecordSerializer;
        this.indexOutput = directory.createOutput(fileName);
        try {
            this.buildBTreeFromIterator(inputIterator);
        }
        catch (IOException e) {
            this.close();
        }
    }

    private void buildBTreeFromIterator(Iterator<G> geoIter) throws IOException {
        this.writeGeoInfo();
        int index = this.getLeftMostLeafIndex();
        this.ensureNotWritingPastEndOfFile(index);
        while (geoIter.hasNext()) {
            this.setValueAtIndex(index, (G)((IGeoRecord)geoIter.next()));
            if ((index = this.getNextIndex(index)) < this.arrayLength) continue;
            throw new IllegalArgumentException("Tree only created for " + this.arrayLength + " nodes but iterator contains more than that");
        }
        this.maxIndex = index;
    }

    private void buildBTreeFromSet(Set<G> geoSet) throws IOException {
        this.buildBTreeFromIterator(geoSet.iterator());
    }

    @Override
    public int getArrayLength() {
        return this.arrayLength;
    }

    @Override
    protected int compareValuesAt(int leftIndex, int rightIndex) {
        throw new UnsupportedOperationException("GeoRecordOutputBTree only supports write operations");
    }

    @Override
    protected boolean isNullNoRangeCheck(int index) {
        throw new UnsupportedOperationException("GeoRecordOutputBTree only supports write operations");
    }

    @Override
    protected G getValueAtIndex(int index) {
        throw new UnsupportedOperationException("GeoRecordOutputBTree only supports write operations");
    }

    @Override
    protected int compare(int index, G value) {
        throw new UnsupportedOperationException("GeoRecordOutputBTree only supports write operations");
    }

    @Override
    protected void setValueAtIndex(int index, G value) throws IOException {
        this.indexOutput.seek(this.getSeekPosForIndex(index));
        this.geoRecordSerializer.writeGeoRecord(this.indexOutput, value, this.geoSegmentInfo.getBytesPerRecord());
    }

    protected long getSeekPosForIndex(int index) {
        return this.treeDataStart + (long)(this.geoSegmentInfo.getBytesPerRecord() * index);
    }

    protected void ensureNotWritingPastEndOfFile(int leftMostLeafIndex) throws IOException {
        long indexOutputLength;
        if (leftMostLeafIndex == 0) {
            return;
        }
        long seekPos = this.getSeekPosForIndex(leftMostLeafIndex);
        if (seekPos > (indexOutputLength = this.indexOutput.length())) {
            long pos = indexOutputLength;
            this.indexOutput.seek(pos);
            long size = Math.min(4096L, seekPos - indexOutputLength);
            int intSize = (int)size;
            byte[] zeroBuf = new byte[intSize];
            Arrays.fill(zeroBuf, (byte)0);
            do {
                size = Math.min(4096L, seekPos - indexOutputLength);
                intSize = (int)size;
                this.indexOutput.writeBytes(zeroBuf, 0, intSize);
                this.indexOutput.seek(pos += (long)intSize);
            } while (seekPos > (indexOutputLength = this.indexOutput.length()));
        }
    }

    private void writeGeoInfo() throws IOException {
        this.indexOutput.writeVInt(this.geoSegmentInfo.getGeoVersion());
        long afterVersionFilePointer = this.indexOutput.getFilePointer();
        this.indexOutput.writeInt(0);
        this.indexOutput.writeVInt(this.arrayLength);
        if (this.geoSegmentInfo.getGeoVersion() > 0) {
            this.indexOutput.writeVInt(this.geoSegmentInfo.getBytesPerRecord());
        }
        IFieldNameFilterConverter filterConverter = this.geoSegmentInfo.getFieldNameFilterConverter();
        filterConverter.writeToOutput((DataOutput)this.indexOutput);
        this.treeDataStart = this.indexOutput.getFilePointer();
        this.indexOutput.seek(afterVersionFilePointer);
        this.indexOutput.writeInt((int)this.treeDataStart);
    }

    @Override
    public void close() throws IOException {
        this.indexOutput.close();
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }
}

