/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.index.impl;

import com.browseengine.bobo.geosearch.IGeoRecordSerializer;
import com.browseengine.bobo.geosearch.bo.GeoRecord;
import com.browseengine.bobo.geosearch.bo.IGeoRecord;
import com.browseengine.bobo.geosearch.impl.BTree;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;

public class GeoSegmentReader<G extends IGeoRecord>
extends BTree<G>
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(GeoSegmentReader.class);
    IndexInput indexInput;
    IGeoRecordSerializer<G> geoRecordSerializer;
    Comparator<G> geoRecordComparator;
    int geoVersion = 0;
    int seekPositionOfIndexZero;
    int bytesPerRecord = 13;
    private final int maxDoc;

    public GeoSegmentReader(Directory dir, String fileName, int maxDoc, int bufferSize, IGeoRecordSerializer<G> geoRecordSerializer, Comparator<G> geoRecordComparator) throws IOException {
        this(0, maxDoc, geoRecordSerializer, geoRecordComparator);
        try {
            this.indexInput = dir.openInput(fileName, bufferSize);
            this.init();
        }
        catch (FileNotFoundException e) {
            LOGGER.warn((Object)("file not found: " + e + ", treating this as no " + GeoRecord.class + "s"));
            this.init(0, this.nullCheckChecksValues);
        }
    }

    protected void init() throws IOException {
        this.geoVersion = this.indexInput.readVInt();
        this.seekPositionOfIndexZero = this.indexInput.readInt();
        int arrayLength = this.indexInput.readVInt();
        if (this.geoVersion > 0) {
            this.bytesPerRecord = this.indexInput.readVInt();
        }
        this.init(arrayLength, this.nullCheckChecksValues);
    }

    protected GeoSegmentReader(int arrayLength, int maxDoc, IGeoRecordSerializer<G> geoRecordSerializer, Comparator<G> geoRecordComparator) {
        super(arrayLength, false);
        this.maxDoc = maxDoc;
        this.geoRecordSerializer = geoRecordSerializer;
        this.geoRecordComparator = geoRecordComparator;
    }

    public int getMaxDoc() {
        return this.maxDoc;
    }

    @Override
    public int getArrayLength() {
        return this.arrayLength;
    }

    @Override
    protected int compareValuesAt(int leftIndex, int rightIndex) throws IOException {
        return this.geoRecordComparator.compare(this.getValueAtIndex(leftIndex), this.getValueAtIndex(rightIndex));
    }

    @Override
    protected int compare(int index, G value) throws IOException {
        return this.geoRecordComparator.compare(this.getValueAtIndex(index), value);
    }

    @Override
    protected boolean isNullNoRangeCheck(int index) {
        return index < this.arrayLength;
    }

    @Override
    protected G getValueAtIndex(int index) throws IOException {
        this.indexInput.seek((long)(this.seekPositionOfIndexZero + this.bytesPerRecord * index));
        return this.geoRecordSerializer.readGeoRecord(this.indexInput, this.bytesPerRecord);
    }

    @Override
    protected void setValueAtIndex(int index, G value) {
        throw new UnsupportedOperationException("SetValueAtIndex is currently unsupported for class GeoRecordRandomAccessAsArray.java");
    }

    @Override
    public void close() throws IOException {
        if (null != this.indexInput) {
            this.indexInput.close();
        }
    }
}

