/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.index.impl;

import com.browseengine.bobo.geosearch.IFieldNameFilterConverter;
import com.browseengine.bobo.geosearch.IGeoConverter;
import com.browseengine.bobo.geosearch.IGeoRecordSerializer;
import com.browseengine.bobo.geosearch.IGeoUtil;
import com.browseengine.bobo.geosearch.bo.GeoRecord;
import com.browseengine.bobo.geosearch.bo.GeoSearchConfig;
import com.browseengine.bobo.geosearch.bo.GeoSegmentInfo;
import com.browseengine.bobo.geosearch.bo.LatitudeLongitudeDocId;
import com.browseengine.bobo.geosearch.impl.GeoRecordSerializer;
import com.browseengine.bobo.geosearch.index.IGeoIndexer;
import com.browseengine.bobo.geosearch.index.bo.GeoCoordinate;
import com.browseengine.bobo.geosearch.index.bo.GeoCoordinateField;
import com.browseengine.bobo.geosearch.index.impl.GeoSegmentWriter;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;

public class GeoIndexer
implements IGeoIndexer {
    IGeoUtil geoUtil;
    IGeoConverter geoConverter;
    GeoSearchConfig config;
    IGeoRecordSerializer<GeoRecord> geoRecordSerializer;
    Set<GeoRecord> fieldTree;
    Set<String> fieldNames = new HashSet<String>();
    private final Object treeLock = new Object();

    public GeoIndexer(GeoSearchConfig config) {
        this.geoUtil = config.getGeoUtil();
        this.geoConverter = config.getGeoConverter();
        this.fieldTree = this.geoUtil.getBinaryTreeOrderedByBitMag();
        this.geoRecordSerializer = new GeoRecordSerializer();
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(int docID, GeoCoordinateField field) {
        String fieldName = field.name();
        GeoCoordinate coordinate = field.getGeoCoordinate();
        LatitudeLongitudeDocId longLatDocId = new LatitudeLongitudeDocId(coordinate.getLatitude(), coordinate.getLongitude(), docID);
        IFieldNameFilterConverter fieldNameFilterConverter = this.geoConverter.makeFieldNameFilterConverter();
        GeoRecord geoRecord = this.geoConverter.toGeoRecord(fieldNameFilterConverter, fieldName, longLatDocId);
        Object object = this.treeLock;
        synchronized (object) {
            this.fieldTree.add(geoRecord);
            this.fieldNames.add(fieldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Directory directory, String segmentName) throws IOException {
        block8: {
            GeoSegmentWriter<GeoRecord> geoRecordBTree;
            block7: {
                Set<GeoRecord> treeToFlush;
                Set<String> fieldNamesToFlush;
                Object object = this.treeLock;
                synchronized (object) {
                    fieldNamesToFlush = this.fieldNames;
                    this.fieldNames = new HashSet<String>();
                    treeToFlush = this.fieldTree;
                    this.fieldTree = this.geoUtil.getBinaryTreeOrderedByBitMag();
                }
                geoRecordBTree = null;
                GeoSegmentInfo geoSegmentInfo = this.buildGeoSegmentInfo(fieldNamesToFlush, segmentName);
                boolean success = false;
                try {
                    String fileName = this.config.getGeoFileName(segmentName);
                    geoRecordBTree = new GeoSegmentWriter<GeoRecord>(treeToFlush, directory, fileName, geoSegmentInfo, this.geoRecordSerializer);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{geoRecordBTree});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{geoRecordBTree});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{geoRecordBTree});
                break block8;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{geoRecordBTree});
        }
    }

    private GeoSegmentInfo buildGeoSegmentInfo(Set<String> fieldNames, String segmentName) throws IOException {
        GeoSegmentInfo info = new GeoSegmentInfo();
        info.setGeoVersion(0);
        info.setSegmentName(segmentName);
        IFieldNameFilterConverter fieldNameFilterConverter = this.geoConverter.makeFieldNameFilterConverter();
        if (fieldNameFilterConverter != null) {
            info.setFieldNameFilterConverter(fieldNameFilterConverter);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Set<GeoRecord> set = this.fieldTree;
        synchronized (set) {
            this.fieldNames.clear();
            this.fieldTree.clear();
        }
    }
}

