/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.index.impl;

import com.browseengine.bobo.geosearch.IGeoRecordSerializer;
import com.browseengine.bobo.geosearch.bo.GeoRecord;
import com.browseengine.bobo.geosearch.bo.GeoSearchConfig;
import com.browseengine.bobo.geosearch.impl.GeoRecordComparator;
import com.browseengine.bobo.geosearch.impl.GeoRecordSerializer;
import com.browseengine.bobo.geosearch.index.impl.GeoSegmentReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.GeoIndexWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;

public class GeoIndexReader
extends FilterIndexReader {
    private static final int DEFAULT_BUFFER_SIZE_PER_SEGMENT = 16384;
    private List<GeoSegmentReader<GeoRecord>> geoSegmentReaders;
    private List<GeoIndexReader> subGeoReaders;
    private final IGeoRecordSerializer<GeoRecord> geoRecordSerializer = new GeoRecordSerializer();
    private final Comparator<GeoRecord> geoRecordComparator = new GeoRecordComparator();

    public GeoIndexReader(Directory directory, GeoSearchConfig geoSearchConfig) throws IOException {
        super(GeoIndexReader.initReader(directory, geoSearchConfig));
        if (this.subGeoReaders == null) {
            this.subGeoReaders = this.buildSubReaders();
        }
        for (GeoIndexReader subGeoReader : this.subGeoReaders) {
            subGeoReader.setGeoSearchConfig(geoSearchConfig);
        }
        this.geoSegmentReaders = this.buildGeoSegmentReaders(geoSearchConfig);
    }

    private GeoIndexReader(IndexReader reader) {
        super(reader);
        if (this.subGeoReaders == null) {
            this.subGeoReaders = this.buildSubReaders();
        }
    }

    private void setGeoSearchConfig(GeoSearchConfig geoSearchConfig) throws IOException {
        for (GeoIndexReader subGeoReader : this.subGeoReaders) {
            subGeoReader.setGeoSearchConfig(geoSearchConfig);
        }
        this.buildGeoSegmentReaders(geoSearchConfig);
    }

    List<GeoIndexReader> buildSubReaders() {
        IndexReader[] baseReaders = super.getSequentialSubReaders();
        int numReaders = baseReaders == null ? 0 : baseReaders.length;
        ArrayList<GeoIndexReader> subGeoReaders = new ArrayList<GeoIndexReader>(numReaders);
        for (int i = 0; i < numReaders; ++i) {
            GeoIndexReader subReader = new GeoIndexReader(baseReaders[i]);
            subGeoReaders.add(subReader);
        }
        return subGeoReaders;
    }

    private List<GeoSegmentReader<GeoRecord>> buildGeoSegmentReaders(GeoSearchConfig geoSearchConfig) throws IOException {
        this.geoSegmentReaders = new ArrayList<GeoSegmentReader<GeoRecord>>();
        if (this.subGeoReaders == null || this.subGeoReaders.size() == 0) {
            if (this.in instanceof SegmentReader) {
                SegmentReader segmentReader = (SegmentReader)this.in;
                int maxDoc = segmentReader.maxDoc();
                String segmentName = segmentReader.getSegmentName();
                String geoSegmentName = geoSearchConfig.getGeoFileName(segmentName);
                GeoSegmentReader<GeoRecord> geoSegmentReader = new GeoSegmentReader<GeoRecord>(this.directory(), geoSegmentName, maxDoc, 16384, this.geoRecordSerializer, this.geoRecordComparator);
                this.geoSegmentReaders.add(geoSegmentReader);
            }
        } else {
            for (GeoIndexReader subReader : this.subGeoReaders) {
                for (GeoSegmentReader<GeoRecord> geoSegmentReader : subReader.getGeoSegmentReaders()) {
                    this.geoSegmentReaders.add(geoSegmentReader);
                }
            }
        }
        return this.geoSegmentReaders;
    }

    private static IndexReader initReader(Directory directory, GeoSearchConfig geoSearchConfig) throws IOException {
        if (null == directory) {
            return null;
        }
        directory = GeoIndexWriter.buildGeoDirectory(directory, geoSearchConfig);
        IndexReader indexReader = IndexReader.open((Directory)directory, (boolean)true);
        return indexReader;
    }

    public List<GeoSegmentReader<GeoRecord>> getGeoSegmentReaders() {
        return this.geoSegmentReaders;
    }

    public IndexReader[] getSequentialSubReaders() {
        if (this.subGeoReaders == null) {
            this.subGeoReaders = this.buildSubReaders();
        }
        if (this.subGeoReaders.size() == 0) {
            return null;
        }
        IndexReader[] subReaders = new IndexReader[this.subGeoReaders.size()];
        for (int i = 0; i < subReaders.length; ++i) {
            subReaders[i] = (IndexReader)this.subGeoReaders.get(i);
        }
        return subReaders;
    }

    public List<GeoIndexReader> getSubGeoReaders() {
        return this.subGeoReaders;
    }

    public void setSubGeoReaders(List<GeoIndexReader> subGeoReaders) {
        this.subGeoReaders = subGeoReaders;
    }

    public void setGeoSegmentReaders(List<GeoSegmentReader<GeoRecord>> geoSegmentReaders) {
        this.geoSegmentReaders = geoSegmentReaders;
    }
}

