/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.index.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;

public class DeletePairedExtensionDirectory
extends Directory {
    private final Directory actualDirectory;
    private final Map<String, String> pairedDeleteExtensions;

    public DeletePairedExtensionDirectory(Directory directory) {
        this.actualDirectory = directory;
        this.pairedDeleteExtensions = new HashMap<String, String>();
    }

    public void addExtensionPairing(String extFrom, String extTo) {
        this.pairedDeleteExtensions.put(extFrom, extTo);
    }

    public String[] listAll() throws IOException {
        return this.actualDirectory.listAll();
    }

    public boolean fileExists(String name) throws IOException {
        return this.actualDirectory.fileExists(name);
    }

    public long fileModified(String name) throws IOException {
        return this.actualDirectory.fileModified(name);
    }

    public void touchFile(String name) throws IOException {
        this.actualDirectory.touchFile(name);
    }

    public void deleteFile(String name) throws IOException {
        String pairedFileName;
        String ext = FilenameUtils.getExtension((String)name);
        String pairedExt = this.pairedDeleteExtensions.get(ext);
        if (StringUtils.isNotBlank((String)pairedExt) && this.fileExists(pairedFileName = FilenameUtils.removeExtension((String)name) + FilenameUtils.EXTENSION_SEPARATOR_STR + pairedExt)) {
            this.deleteFile(pairedFileName);
        }
        this.actualDirectory.deleteFile(name);
    }

    public long fileLength(String name) throws IOException {
        return this.actualDirectory.fileLength(name);
    }

    public IndexOutput createOutput(String name) throws IOException {
        return this.actualDirectory.createOutput(name);
    }

    public void sync(String name) throws IOException {
        this.actualDirectory.sync(name);
    }

    public void sync(Collection<String> names) throws IOException {
        this.actualDirectory.sync(names);
    }

    public IndexInput openInput(String name) throws IOException {
        return this.actualDirectory.openInput(name);
    }

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        return this.actualDirectory.openInput(name, bufferSize);
    }

    public Lock makeLock(String name) {
        return this.actualDirectory.makeLock(name);
    }

    public void clearLock(String name) throws IOException {
        this.actualDirectory.clearLock(name);
    }

    public void close() throws IOException {
        this.actualDirectory.close();
    }

    public void setLockFactory(LockFactory lockFactory) throws IOException {
        this.actualDirectory.setLockFactory(lockFactory);
    }

    public LockFactory getLockFactory() {
        return this.actualDirectory.getLockFactory();
    }

    public String getLockID() {
        return this.actualDirectory.getLockID();
    }

    public String toString() {
        return this.actualDirectory.toString();
    }

    public void copy(Directory to, String src, String dest) throws IOException {
        this.actualDirectory.copy(to, src, dest);
    }
}

