/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.impl;

import com.browseengine.bobo.geosearch.impl.BTree;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class TreeIterator<T>
implements Iterator<T> {
    private final int rightIndex;
    private int index;
    private BTree<T> treeAsArray;

    public TreeIterator(BTree<T> treeAsArray, int leftIndex, int rightIndex) {
        this.treeAsArray = treeAsArray;
        this.index = leftIndex;
        this.rightIndex = rightIndex;
    }

    @Override
    public boolean hasNext() {
        return this.index != -1;
    }

    @Override
    public T next() {
        try {
            if (this.index == -1) {
                throw new NoSuchElementException();
            }
            T value = this.treeAsArray.getValueAtIndex(this.index);
            this.index = this.index == this.rightIndex ? -1 : this.treeAsArray.getNextIndex(this.index);
            return value;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

