/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.impl;

import com.browseengine.bobo.geosearch.IFieldNameFilterConverter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.springframework.stereotype.Component;

@Component
public class MappedFieldNameFilterConverter
implements IFieldNameFilterConverter {
    public static final int FIELD_FILTER_VERSION = 0;
    Map<String, Byte> bitmasks = new HashMap<String, Byte>();

    public void addFieldBitMask(String fieldName, byte bitMask) {
        this.bitmasks.put(fieldName, bitMask);
    }

    @Override
    public byte getFilterValue(String[] fieldNames) {
        if (fieldNames == null || fieldNames.length == 0) {
            return 0;
        }
        byte filterByte = 0;
        for (String fieldName : fieldNames) {
            Byte bitmask = this.bitmasks.get(fieldName);
            if (bitmask == null) continue;
            filterByte = (byte)(filterByte | bitmask);
        }
        return filterByte;
    }

    @Override
    public List<String> getFields(byte filterValue) {
        Vector<String> filterFields = new Vector<String>();
        for (Map.Entry<String, Byte> bitmaskEntry : this.bitmasks.entrySet()) {
            String field = bitmaskEntry.getKey();
            Byte bitmask = bitmaskEntry.getValue();
            if ((filterValue & bitmask) == 0) continue;
            filterFields.add(field);
        }
        return filterFields;
    }

    @Override
    public boolean fieldIsInFilter(String fieldName, byte filterValue) {
        Byte bitmask = this.bitmasks.get(fieldName);
        return bitmask != null && (filterValue & bitmask) != 0;
    }

    @Override
    public void writeToOutput(DataOutput output) throws IOException {
        output.writeVInt(0);
        if (this.bitmasks != null) {
            output.writeVInt(this.bitmasks.size());
            for (Map.Entry<String, Byte> filterEntry : this.bitmasks.entrySet()) {
                output.writeString(filterEntry.getKey());
                output.writeByte(filterEntry.getValue().byteValue());
            }
        } else {
            output.writeVInt(0);
        }
    }

    @Override
    public void loadFromInput(DataInput input) throws IOException {
        input.readVInt();
        int mapSize = input.readVInt();
        this.bitmasks = new HashMap<String, Byte>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            String fieldName = input.readString();
            Byte filterByte = input.readByte();
            this.bitmasks.put(fieldName, filterByte);
        }
    }
}

