/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.impl;

import com.browseengine.bobo.geosearch.IGeoUtil;
import com.browseengine.bobo.geosearch.bo.GeoRecord;
import com.browseengine.bobo.geosearch.bo.LatitudeLongitudeDocId;
import com.browseengine.bobo.geosearch.impl.GeoConverter;
import com.browseengine.bobo.geosearch.impl.GeoRecordComparator;
import com.browseengine.bobo.geosearch.impl.GeoRecordCompareByDocId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.springframework.stereotype.Component;

@Component
public class GeoUtil
implements IGeoUtil {
    private static final double MINIMUM_LONGITUDE_EXCLUSIVE = -180.0;
    private static final double MAXIMUM_LONGITUDE_INCLUSIVE = 180.0;
    private static final double MINIMUM_LATITUDE_INCLUSIVE = -90.0;
    private static final double MAXIMUM_LATITUDE_INCLUSIVE = 90.0;

    @Override
    public Iterator<GeoRecord> getGeoRecordIterator(Iterator<LatitudeLongitudeDocId> lldidIter) {
        GeoConverter gc = new GeoConverter();
        ArrayList<GeoRecord> grl = new ArrayList<GeoRecord>();
        while (lldidIter.hasNext()) {
            grl.add(gc.toGeoRecord(null, null, lldidIter.next()));
        }
        return grl.iterator();
    }

    @Override
    public TreeSet<GeoRecord> getBinaryTreeOrderedByBitMag(Iterator<GeoRecord> grIter) {
        TreeSet<GeoRecord> tree = this.getBinaryTreeOrderedByBitMag();
        while (grIter.hasNext()) {
            tree.add(grIter.next());
        }
        return tree;
    }

    @Override
    public TreeSet<GeoRecord> getBinaryTreeOrderedByBitMag() {
        return new TreeSet<GeoRecord>(new GeoRecordComparator());
    }

    @Override
    public TreeSet<GeoRecord> getBinaryTreeOrderedByDocId(Iterator<GeoRecord> grtIter) {
        TreeSet<Object> tree = new TreeSet<Object>(new GeoRecordCompareByDocId());
        while (grtIter.hasNext()) {
            tree.add(grtIter.next());
        }
        return tree;
    }

    @Override
    public Iterator<GeoRecord> getGeoRecordRangeIterator(TreeSet<GeoRecord> tree, GeoRecord minRange, GeoRecord maxRange) {
        return tree.subSet(minRange, maxRange).iterator();
    }

    public static boolean isValidLongitude(Double longitude) {
        return null != longitude && -180.0 < longitude && longitude <= 180.0;
    }

    public static boolean isValidLatitude(Double latitude) {
        return null != latitude && -90.0 <= latitude && latitude <= 90.0;
    }
}

