/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.impl;

import com.browseengine.bobo.geosearch.IGeoRecordIterator;
import com.browseengine.bobo.geosearch.bo.GeoRecord;
import com.browseengine.bobo.geosearch.bo.GeoSegmentInfo;
import com.browseengine.bobo.geosearch.impl.BTree;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.store.Directory;

public class GeoRecordBTree
extends BTree<GeoRecord>
implements IGeoRecordIterator {
    public static final long HIGH_ORDER_NULL_NODE_VALUE = -1L;
    private final long[] highOrders;
    private final int[] lowOrders;
    private final byte[] filterBytes;

    public GeoRecordBTree(int treeSize, Iterator<GeoRecord> inputIterator, Directory directory, String fileName, GeoSegmentInfo geoSegmentInfo) throws IOException {
        super(treeSize, false);
        this.highOrders = new long[this.arrayLength];
        this.lowOrders = new int[this.arrayLength];
        this.filterBytes = new byte[this.arrayLength];
        this.buildTreeFromIterator(inputIterator);
        this.nullCheckChecksValues = true;
    }

    public GeoRecordBTree(Set<GeoRecord> tree) throws IOException {
        super(tree.size(), false);
        this.highOrders = new long[this.arrayLength];
        this.lowOrders = new int[this.arrayLength];
        this.filterBytes = new byte[this.arrayLength];
        Iterator<GeoRecord> it = tree.iterator();
        this.buildTreeFromIterator(it);
        this.nullCheckChecksValues = true;
    }

    private void buildTreeFromIterator(Iterator<GeoRecord> geoIter) throws IOException {
        int index = this.leftMostLeafIndex;
        while (geoIter.hasNext()) {
            GeoRecord geoRecord = geoIter.next();
            this.highOrders[index] = geoRecord.highOrder;
            this.lowOrders[index] = geoRecord.lowOrder;
            this.filterBytes[index] = geoRecord.filterByte;
            index = this.getNextIndex(index);
        }
    }

    public GeoRecordBTree(long[] highOrders, int[] lowOrders, byte[] filterBytes) {
        super(highOrders.length, true);
        this.highOrders = highOrders;
        this.lowOrders = lowOrders;
        this.filterBytes = filterBytes;
    }

    @Override
    public int getArrayLength() {
        return this.highOrders.length;
    }

    @Override
    protected int compare(int index, GeoRecord value) {
        return this.compare(this.highOrders[index], this.lowOrders[index], value.highOrder, value.lowOrder);
    }

    private int compare(long leftHighOrder, int leftLowOrder, long rightHighOrder, int rightLowOrder) {
        long diff = leftHighOrder - rightHighOrder;
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        int idiff = leftLowOrder - rightLowOrder;
        if (idiff < 0) {
            return -1;
        }
        if (idiff > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    protected int compareValuesAt(int leftIndex, int rightIndex) {
        return this.compare(this.highOrders[leftIndex], this.lowOrders[leftIndex], this.highOrders[rightIndex], this.lowOrders[rightIndex]);
    }

    @Override
    public GeoRecord getValueAtIndex(int index) {
        return new GeoRecord(this.highOrders[index], this.lowOrders[index], this.filterBytes[index]);
    }

    @Override
    protected boolean isNullNoRangeCheck(int index) {
        long highOrder = this.highOrders[index];
        return -1L == highOrder;
    }

    public long[] getHighOrders() {
        return this.highOrders;
    }

    public int[] getLowOrders() {
        return this.lowOrders;
    }

    public byte[] getFilterBytes() {
        return this.filterBytes;
    }

    public static long getHighOrderNullNodeValue() {
        return -1L;
    }

    @Override
    protected void setValueAtIndex(int index, GeoRecord value) throws IOException {
        this.highOrders[index] = value.highOrder;
        this.lowOrders[index] = value.lowOrder;
        this.filterBytes[index] = value.filterByte;
    }

    @Override
    public void close() throws IOException {
    }
}

