/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.impl;

import com.browseengine.bobo.geosearch.IFieldNameFilterConverter;
import com.browseengine.bobo.geosearch.IGeoConverter;
import com.browseengine.bobo.geosearch.bo.CartesianCoordinateUUID;
import com.browseengine.bobo.geosearch.bo.GeoRecord;
import com.browseengine.bobo.geosearch.bo.LatitudeLongitudeDocId;
import com.browseengine.bobo.geosearch.impl.MappedFieldNameFilterConverter;
import com.browseengine.bobo.geosearch.score.impl.Conversions;
import com.browseengine.bobo.geosearch.solo.bo.IDGeoRecord;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class GeoConverter
implements IGeoConverter {
    private static final double PIRADIANS = 180.0;
    private static final int LONGLENGTH = 64;
    private static final int INTLENGTH = 32;
    private static final long ONE_AS_LONG = 1L;
    private static final int ONE_AS_INT = 1;
    Map<String, Byte> bitmasks = new HashMap<String, Byte>();
    static final double ONE_MINUS_ECCENTRICITY_OF_EARTH = 0.99330562;

    @Override
    public void addFieldBitMask(String fieldName, byte bitMask) {
        this.bitmasks.put(fieldName, bitMask);
    }

    @Override
    public IFieldNameFilterConverter makeFieldNameFilterConverter() {
        MappedFieldNameFilterConverter mappedFieldNameFilterConverter = new MappedFieldNameFilterConverter();
        for (Map.Entry<String, Byte> bitmask : this.bitmasks.entrySet()) {
            String fieldName = bitmask.getKey();
            Byte bitMask = bitmask.getValue();
            mappedFieldNameFilterConverter.addFieldBitMask(fieldName, bitMask);
        }
        return mappedFieldNameFilterConverter;
    }

    @Override
    public LatitudeLongitudeDocId toLongitudeLatitudeDocId(GeoRecord geoRecord) {
        long lShift = 63L;
        int iShift = 31;
        int docPlace = 31;
        double lngDivisor = 180.0;
        double latDivisor = 90.0;
        int lob = geoRecord.lowOrder << 1;
        long hob = geoRecord.highOrder;
        int docid = 0;
        double lng = 0.0;
        double lat = 0.0;
        while (iShift > -1) {
            if (lShift > -1L) {
                if ((hob & 1L << (int)lShift) == 1L << (int)lShift) {
                    docid += 1 << docPlace;
                }
                --lShift;
                --docPlace;
            } else {
                if ((lob & 1 << iShift) == 1 << iShift) {
                    docid += 1 << docPlace;
                }
                --iShift;
                --docPlace;
            }
            if (lShift > -1L) {
                if ((hob & 1L << (int)lShift) == 1L << (int)lShift) {
                    lng += lngDivisor;
                }
                --lShift;
                lngDivisor /= 2.0;
            } else {
                if ((lob & 1 << iShift) == 1 << iShift) {
                    lng += lngDivisor;
                }
                --iShift;
                lngDivisor /= 2.0;
            }
            if (lShift > -1L) {
                if ((hob & 1L << (int)lShift) == 1L << (int)lShift) {
                    lat += latDivisor;
                }
                --lShift;
                latDivisor /= 2.0;
                continue;
            }
            if ((lob & 1 << iShift) == 1 << iShift) {
                lat += latDivisor;
            }
            --iShift;
            latDivisor /= 2.0;
        }
        return new LatitudeLongitudeDocId(lat -= 90.0, lng -= 180.0, docid);
    }

    @Override
    public GeoRecord toGeoRecord(IFieldNameFilterConverter fieldNameFilterConverter, String fieldName, LatitudeLongitudeDocId longitudeLatitudeDocId) {
        byte filterByte = fieldNameFilterConverter == null ? (byte)0 : fieldNameFilterConverter.getFilterValue(new String[]{fieldName});
        return this.toGeoRecord(filterByte, longitudeLatitudeDocId);
    }

    @Override
    public GeoRecord toGeoRecord(byte filterByte, LatitudeLongitudeDocId latitudeLongitudeDocId) {
        double lng = latitudeLongitudeDocId.longitude + 180.0;
        double lat = latitudeLongitudeDocId.latitude + 90.0;
        double lngDivisor = 180.0;
        double latDivisor = 90.0;
        long lShift = 63L;
        int iShift = 31;
        long hob = 0L;
        int lob = 0;
        int docPlace = 31;
        while (iShift > -1) {
            if ((latitudeLongitudeDocId.docid & 1 << docPlace) == 1 << docPlace) {
                if (lShift > -1L) {
                    hob += 1L << (int)lShift;
                    --lShift;
                } else {
                    lob += 1 << iShift;
                    --iShift;
                }
                --docPlace;
            } else {
                --docPlace;
                if (lShift > -1L) {
                    --lShift;
                } else {
                    --iShift;
                }
            }
            if (lng / lngDivisor >= 1.0) {
                lng -= lngDivisor;
                if (lShift > -1L) {
                    hob += 1L << (int)lShift;
                    --lShift;
                } else {
                    lob += 1 << iShift;
                    --iShift;
                }
            } else if (lShift > -1L) {
                --lShift;
            } else {
                --iShift;
            }
            lngDivisor /= 2.0;
            if (lat / latDivisor >= 1.0) {
                lat -= latDivisor;
                if (lShift > -1L) {
                    hob += 1L << (int)lShift;
                    --lShift;
                } else {
                    lob += 1 << iShift;
                    --iShift;
                }
            } else if (lShift > -1L) {
                --lShift;
            } else {
                --iShift;
            }
            latDivisor /= 2.0;
        }
        return new GeoRecord(hob, lob >>>= 1, filterByte);
    }

    protected int getXFromRadians(double latRadians, double longRadians) {
        return (int)(2.14E9 * Math.cos(latRadians) * Math.cos(longRadians));
    }

    protected int getYFromRadians(double latRadians, double longRadians) {
        return (int)(2.14E9 * Math.cos(latRadians) * Math.sin(longRadians));
    }

    protected int getZFromRadians(double latRadians) {
        return (int)(2.1256740268E9 * Math.sin(latRadians));
    }

    @Override
    public IDGeoRecord toIDGeoRecord(CartesianCoordinateUUID coordinate) {
        return this.toIDGeoRecord(coordinate.x, coordinate.y, coordinate.z, coordinate.uuid);
    }

    @Override
    public CartesianCoordinateUUID toCartesianCoordinate(double latitude, double longitude, byte[] uuid) {
        double latRadians = Conversions.d2r(latitude);
        double longRadians = Conversions.d2r(longitude);
        int x = this.getXFromRadians(latRadians, longRadians);
        int y = this.getYFromRadians(latRadians, longRadians);
        int z = this.getZFromRadians(latRadians);
        return new CartesianCoordinateUUID(x, y, z, uuid);
    }

    @Override
    public IDGeoRecord toIDGeoRecord(double latitude, double longitude, byte[] uuid) {
        double latRadians = Conversions.d2r(latitude);
        double longRadians = Conversions.d2r(longitude);
        int x = this.getXFromRadians(latRadians, longRadians);
        int y = this.getYFromRadians(latRadians, longRadians);
        int z = this.getZFromRadians(latRadians);
        return this.toIDGeoRecord(x, y, z, uuid);
    }

    protected IDGeoRecord toIDGeoRecord(int x, int y, int z, byte[] uuid) {
        long highOrderBits = 0L;
        int highOrderPosition = 62;
        if (x < 0) {
            x += Integer.MIN_VALUE;
        } else {
            highOrderBits += 1L << highOrderPosition;
        }
        --highOrderPosition;
        if (y < 0) {
            y += Integer.MIN_VALUE;
        } else {
            highOrderBits += 1L << highOrderPosition;
        }
        --highOrderPosition;
        if (z < 0) {
            z += Integer.MIN_VALUE;
        } else {
            highOrderBits += 1L << highOrderPosition;
        }
        int xPos = 30;
        int yPos = 30;
        int zPos = 30;
        highOrderBits = this.interlaceToLong(x, 30, highOrderBits, --highOrderPosition, 3);
        xPos -= highOrderPosition / 3 + 1;
        highOrderBits = this.interlaceToLong(y, 30, highOrderBits, --highOrderPosition, 3);
        yPos -= highOrderPosition / 3 + 1;
        highOrderBits = this.interlaceToLong(z, 30, highOrderBits, --highOrderPosition, 3);
        int lowOrderBits = 0;
        int lowOrderPosition = 30;
        lowOrderBits = this.interlaceToInteger(x, xPos, lowOrderBits, lowOrderPosition, 3);
        lowOrderBits = this.interlaceToInteger(y, yPos, lowOrderBits, --lowOrderPosition, 3);
        lowOrderBits = this.interlaceToInteger(z, zPos -= highOrderPosition / 3 + 1, lowOrderBits, --lowOrderPosition, 3);
        return new IDGeoRecord(highOrderBits, lowOrderBits, uuid);
    }

    private long interlaceToLong(int inputValue, int inputBitPosition, long longValue, int longBitPosition, int interlaceInterval) {
        while (longBitPosition > -1 && inputBitPosition > -1) {
            if ((inputValue & 1 << inputBitPosition) != 0) {
                longValue += 1L << longBitPosition;
            }
            longBitPosition -= interlaceInterval;
            --inputBitPosition;
        }
        return longValue;
    }

    private int interlaceToInteger(int inputValue, int inputBitPosition, int integerValue, int integerBitPosition, int interlaceInterval) {
        while (integerBitPosition > -1 && inputBitPosition > -1) {
            if ((inputValue & 1 << inputBitPosition) != 0) {
                integerValue += 1 << integerBitPosition;
            }
            integerBitPosition -= interlaceInterval;
            --inputBitPosition;
        }
        return integerValue;
    }

    @Override
    public CartesianCoordinateUUID toCartesianCoordinate(IDGeoRecord geoRecord) {
        int x = 0;
        int y = 0;
        int z = 0;
        int dimensions = 3;
        int highOrderPosition = 62 - dimensions;
        int xPos = 30;
        int yPos = 30;
        int zPos = 30;
        x = this.unInterlaceFromLong(x, xPos, geoRecord.highOrder, highOrderPosition, dimensions);
        xPos -= highOrderPosition / dimensions + 1;
        y = this.unInterlaceFromLong(y, yPos, geoRecord.highOrder, --highOrderPosition, dimensions);
        yPos -= highOrderPosition / dimensions + 1;
        z = this.unInterlaceFromLong(z, zPos, geoRecord.highOrder, --highOrderPosition, dimensions);
        int lowOrderPosition = 30;
        x = this.unInterlaceFromInt(x, xPos, geoRecord.lowOrder, lowOrderPosition, dimensions);
        y = this.unInterlaceFromInt(y, yPos, geoRecord.lowOrder, --lowOrderPosition, dimensions);
        z = this.unInterlaceFromInt(z, zPos -= highOrderPosition / dimensions + 1, geoRecord.lowOrder, --lowOrderPosition, dimensions);
        highOrderPosition = 62;
        if ((geoRecord.highOrder & 1L << highOrderPosition) == 0L) {
            x -= Integer.MIN_VALUE;
        }
        if ((geoRecord.highOrder & 1L << --highOrderPosition) == 0L) {
            y -= Integer.MIN_VALUE;
        }
        if ((geoRecord.highOrder & 1L << --highOrderPosition) == 0L) {
            z -= Integer.MIN_VALUE;
        }
        --highOrderPosition;
        return new CartesianCoordinateUUID(x, y, z, geoRecord.id);
    }

    private int unInterlaceFromLong(int outputValue, int outputBitPos, long longValue, int longBitPosition, int interlaceInterval) {
        while (longBitPosition > -1 && outputBitPos > -1) {
            if ((longValue & 1L << longBitPosition) != 0L) {
                outputValue += 1 << outputBitPos;
            }
            longBitPosition -= interlaceInterval;
            --outputBitPos;
        }
        return outputValue;
    }

    private int unInterlaceFromInt(int outputValue, int outputBitPos, int intValue, int intBitPosition, int interlaceInterval) {
        while (intBitPosition > -1 && outputBitPos > -1) {
            if ((intValue & 1 << intBitPosition) != 0) {
                outputValue += 1 << outputBitPos;
            }
            intBitPosition -= interlaceInterval;
            --outputBitPos;
        }
        return outputValue;
    }
}

