/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.impl;

import com.browseengine.bobo.geosearch.IDeletedDocs;
import com.browseengine.bobo.geosearch.IGeoBlockOfHitsProvider;
import com.browseengine.bobo.geosearch.IGeoConverter;
import com.browseengine.bobo.geosearch.bo.DocsSortedByDocId;
import com.browseengine.bobo.geosearch.bo.GeoRecord;
import com.browseengine.bobo.geosearch.bo.GeoRecordAndLongitudeLatitudeDocId;
import com.browseengine.bobo.geosearch.bo.LatitudeLongitudeDocId;
import com.browseengine.bobo.geosearch.index.impl.GeoSegmentReader;
import java.io.IOException;
import java.util.Iterator;

public class GeoBlockOfHitsProvider
implements IGeoBlockOfHitsProvider {
    private IGeoConverter geoConverter;

    public GeoBlockOfHitsProvider(IGeoConverter geoConverter) {
        this.geoConverter = geoConverter;
    }

    @Override
    public DocsSortedByDocId getBlock(GeoSegmentReader geoSegmentReader, IDeletedDocs deletedDocsWithinSegment, double minimumLongitude, double minimumLatitude, int minimumDocid, double maximumLongitude, double maximumLatitude, int maximumDocid) throws IOException {
        boolean filterByte = false;
        LatitudeLongitudeDocId minRaw = new LatitudeLongitudeDocId(minimumLatitude, minimumLongitude, minimumDocid);
        GeoRecord minValue = this.geoConverter.toGeoRecord((byte)0, minRaw);
        LatitudeLongitudeDocId maxRaw = new LatitudeLongitudeDocId(maximumLatitude, maximumLongitude, maximumDocid);
        GeoRecord maxValue = this.geoConverter.toGeoRecord((byte)0, maxRaw);
        Iterator<GeoRecord> iterator = geoSegmentReader.getIterator(minValue, maxValue);
        DocsSortedByDocId docs = new DocsSortedByDocId();
        while (iterator.hasNext()) {
            GeoRecord geoRecord = iterator.next();
            LatitudeLongitudeDocId longitudeLatitudeDocId = this.geoConverter.toLongitudeLatitudeDocId(geoRecord);
            if (!(minimumLongitude <= longitudeLatitudeDocId.longitude) || !(longitudeLatitudeDocId.longitude <= maximumLongitude) || !(minimumLatitude <= longitudeLatitudeDocId.latitude) || !(longitudeLatitudeDocId.latitude <= maximumLatitude) || minimumDocid > longitudeLatitudeDocId.docid || longitudeLatitudeDocId.docid > maximumDocid) continue;
            GeoRecordAndLongitudeLatitudeDocId both = new GeoRecordAndLongitudeLatitudeDocId(geoRecord, longitudeLatitudeDocId);
            docs.add(longitudeLatitudeDocId.docid, both);
        }
        return docs;
    }
}

