/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.impl;

import com.browseengine.bobo.geosearch.impl.BTree;
import java.io.IOException;
import java.util.LinkedList;

public class CostOfBTree<V>
extends BTree<V> {
    private final BTree<V> tree;
    private final LinkedList<Integer> previousIndexes;
    private static final int MAX_SIZE_PREVIOUS_INDEXES = 3;
    private int costCounter;

    public CostOfBTree(BTree<V> tree) {
        super(tree.getArrayLength(), true);
        this.tree = tree;
        this.previousIndexes = new LinkedList();
        this.costCounter = 0;
    }

    @Override
    public int getArrayLength() {
        return this.tree.getArrayLength();
    }

    @Override
    protected int compare(int index, V value) throws IOException {
        this.incrementCostCounter(index);
        return this.tree.compare(index, value);
    }

    private void incrementCostCounter(int index) {
        Integer indexAsInteger = index;
        if (!this.previousIndexes.remove(indexAsInteger)) {
            ++this.costCounter;
            if (this.previousIndexes.size() >= 3) {
                this.previousIndexes.removeLast();
            }
        }
        this.previousIndexes.addFirst(indexAsInteger);
    }

    @Override
    protected int compareValuesAt(int leftIndex, int rightIndex) throws IOException {
        this.incrementCostCounter(leftIndex);
        this.incrementCostCounter(rightIndex);
        return this.tree.compareValuesAt(leftIndex, rightIndex);
    }

    @Override
    protected V getValueAtIndex(int index) throws IOException {
        this.incrementCostCounter(index);
        return this.tree.getValueAtIndex(index);
    }

    @Override
    protected boolean isNullNoRangeCheck(int index) throws IOException {
        this.incrementCostCounter(index);
        return this.tree.isNullNoRangeCheck(index);
    }

    @Override
    protected void setValueAtIndex(int index, V value) throws IOException {
        this.incrementCostCounter(index);
        this.tree.setValueAtIndex(index, value);
    }

    @Override
    public void close() throws IOException {
        this.tree.close();
    }
}

