/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.impl;

import com.browseengine.bobo.geosearch.impl.NoHitsIterator;
import com.browseengine.bobo.geosearch.impl.TreeIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class BTree<V>
implements Closeable {
    protected static final int INDEX_OUT_OF_BOUNDS = -1;
    protected static final int ROOT_INDEX = 0;
    protected int arrayLength;
    protected boolean nullCheckChecksValues;
    final int height;
    final int leftMostLeafIndex;
    private static int[] NODES_OF_HEIGHT = new int[32];

    public BTree(int arrayLength, boolean nullCheckChecksValues) {
        this.init(arrayLength, nullCheckChecksValues);
        this.arrayLength = arrayLength;
        this.nullCheckChecksValues = nullCheckChecksValues;
        this.height = this.getDepthOf(arrayLength - 1) + 1;
        this.leftMostLeafIndex = (1 << this.height - 1) - 1;
    }

    protected void init(int arrayLength, boolean nullCheckChecksValues) {
        this.arrayLength = arrayLength;
        this.nullCheckChecksValues = nullCheckChecksValues;
    }

    public int getNextIndex(int index) throws IOException {
        if (this.hasRightChild(index)) {
            index = this.getRightChildIndex(index);
            while (this.hasLeftChild(index)) {
                index = this.getLeftChildIndex(index);
            }
            return index;
        }
        while (this.isARightChild(index)) {
            index = this.getParentIndex(index);
        }
        if (this.isALeftChild(index)) {
            index = this.getParentIndex(index);
            return index;
        }
        return -1;
    }

    public int getHeight() {
        return this.height;
    }

    public abstract int getArrayLength();

    public int getLeftChildIndex(int index) {
        return (index + 1) * 2 - 1;
    }

    public int getRightChildIndex(int index) {
        return this.getLeftChildIndex(index) + 1;
    }

    public int getParentIndex(int index) {
        return (index - 1) / 2;
    }

    public boolean isALeftChild(int index) {
        if (index == 0) {
            return false;
        }
        return index % 2 == 1;
    }

    public boolean isARightChild(int index) {
        if (index == 0) {
            return false;
        }
        return !this.isALeftChild(index);
    }

    public boolean hasRightChild(int index) throws IOException {
        int rightChildIndex = this.getRightChildIndex(index);
        return !this.isNull(rightChildIndex);
    }

    public boolean hasLeftChild(int index) throws IOException {
        int leftChildIndex = this.getLeftChildIndex(index);
        return !this.isNull(leftChildIndex);
    }

    public Iterator<V> getIterator(V minValue, V maxValue) throws IOException {
        int leftIndex = this.getIndexOfSmallestNodeGreaterThanOrEqualTo(minValue);
        int rightIndex = this.getIndexOfLargestNodeLessThanOrEqualTo(maxValue);
        if (leftIndex >= 0 && rightIndex >= 0 && this.compareValuesAt(leftIndex, rightIndex) <= 0) {
            return new TreeIterator(this, leftIndex, rightIndex);
        }
        return new NoHitsIterator();
    }

    protected int getDepthOf(int index) {
        int depth = 0;
        ++index;
        while (index > 1) {
            index /= 2;
            ++depth;
        }
        return depth;
    }

    protected int getLeftMostLeafIndex() {
        return this.leftMostLeafIndex;
    }

    public int getUpperBoundOnNumberOfNodes(V minValue, V maxValue) throws IOException {
        Path leftPath = new Path();
        Path rightPath = new Path();
        int leftIndex = this.getIndexOfSmallestNodeGreaterThanOrEqualTo(minValue, leftPath, maxValue);
        int rightIndex = this.getIndexOfLargestNodeLessThanOrEqualTo(maxValue, rightPath, minValue);
        if (leftIndex >= 0 && rightIndex >= 0 && this.compareValuesAt(leftIndex, rightIndex) <= 0) {
            int someNodeIndex;
            if (leftIndex == rightIndex) {
                return 1;
            }
            if (leftPath.isConnected() && rightPath.isConnected()) {
                if (leftPath.contains(rightIndex)) {
                    return this.getCase2(leftIndex, rightIndex);
                }
                if (rightPath.contains(leftIndex)) {
                    return this.getCase2(rightIndex, leftIndex);
                }
                someNodeIndex = leftPath.get(0);
                if (leftPath.isConnected() && rightPath.isConnected()) {
                    return this.getCase2(leftIndex, someNodeIndex) + this.getCase2(rightIndex, someNodeIndex) - 1;
                }
            }
            someNodeIndex = leftPath.get(0);
            return this.getCountDisconnected(leftPath, rightPath, leftIndex, rightIndex, someNodeIndex);
        }
        return 0;
    }

    private int getCountDisconnected(Path leftPath, Path rightPath, int leftIndex, int rightIndex, int someNodeIndex) {
        int currentNodeIndex;
        int i;
        int sum = 0;
        boolean highestHitCounted = false;
        if (leftPath.isConnected()) {
            highestHitCounted = true;
            sum += this.getCase2(leftIndex, someNodeIndex);
        } else {
            for (i = 1; i < leftPath.size(); ++i) {
                currentNodeIndex = leftPath.get(i);
                sum += this.getNodesInTreeRootedAt(this.getDepthOf(currentNodeIndex) + 1) + 1;
            }
        }
        if (rightPath.isConnected()) {
            sum += this.getCase2(rightIndex, someNodeIndex);
            if (highestHitCounted) {
                --sum;
            } else {
                highestHitCounted = true;
            }
        } else {
            for (i = 1; i < rightPath.size(); ++i) {
                currentNodeIndex = rightPath.get(i);
                sum += this.getNodesInTreeRootedAt(this.getDepthOf(currentNodeIndex) + 1) + 1;
            }
        }
        if (!highestHitCounted) {
            ++sum;
        }
        return sum;
    }

    private int getCase2(int indexLowerInTheTree, int indexHigherInTheTree) {
        int sum = 1;
        int depthOfLower = this.getDepthOf(indexLowerInTheTree);
        int depthOfHigher = this.getDepthOf(indexHigherInTheTree);
        for (int depth = depthOfLower; depth > depthOfHigher; --depth) {
            sum += this.getNodesInTreeRootedAt(depth + 1) + 1;
        }
        return sum;
    }

    private int getNodesInTreeRootedAt(int depth) {
        int heightOfSubtree = this.height - depth;
        if (heightOfSubtree >= 0) {
            return NODES_OF_HEIGHT[heightOfSubtree];
        }
        return 0;
    }

    protected int getIndexOfSmallestNodeGreaterThanOrEqualToStartingFrom(V minValue, int index, int candidateIndex, Path candidateIndexes, V maxValue) throws IOException {
        if (this.isNull(index)) {
            return candidateIndex;
        }
        int comparison = this.compare(index, minValue);
        if (comparison > 0) {
            int leftChildIndex = this.getLeftChildIndex(index);
            this.addToCandidateIndexes(candidateIndexes, index, maxValue, true);
            return this.getIndexOfSmallestNodeGreaterThanOrEqualToStartingFrom(minValue, leftChildIndex, index, candidateIndexes, maxValue);
        }
        if (comparison < 0) {
            int rightChildIndex = this.getRightChildIndex(index);
            return this.getIndexOfSmallestNodeGreaterThanOrEqualToStartingFrom(minValue, rightChildIndex, candidateIndex, candidateIndexes, maxValue);
        }
        this.addToCandidateIndexes(candidateIndexes, index, maxValue, true);
        return index;
    }

    protected int getIndexOfSmallestNodeGreaterThanOrEqualTo(V minValue, Path candidateIndexes, V maxValue) throws IOException {
        return this.getIndexOfSmallestNodeGreaterThanOrEqualToStartingFrom(minValue, 0, -1, candidateIndexes, maxValue);
    }

    public int getIndexOfSmallestNodeGreaterThanOrEqualTo(V minValue) throws IOException {
        return this.getIndexOfSmallestNodeGreaterThanOrEqualToStartingFrom(minValue, 0, -1, null, null);
    }

    protected int getIndexOfLargestNodeLessThanOrEqualTo(V maxValue, Path candidateIndexes, V minValue) throws IOException {
        return this.getIndexOfLargestNodeLessThanOrEqualToStartingFrom(maxValue, 0, -1, candidateIndexes, minValue);
    }

    public int getIndexOfLargestNodeLessThanOrEqualTo(V maxValue) throws IOException {
        return this.getIndexOfLargestNodeLessThanOrEqualToStartingFrom(maxValue, 0, -1, null, null);
    }

    protected int getIndexOfLargestNodeLessThanOrEqualToStartingFrom(V maxValue, int index, int candidateIndex, Path candidateIndexes, V minValue) throws IOException {
        if (this.isNull(index)) {
            return candidateIndex;
        }
        int comparison = this.compare(index, maxValue);
        if (comparison > 0) {
            int leftChildIndex = this.getLeftChildIndex(index);
            return this.getIndexOfLargestNodeLessThanOrEqualToStartingFrom(maxValue, leftChildIndex, candidateIndex, candidateIndexes, minValue);
        }
        if (comparison < 0) {
            int rightChildIndex = this.getRightChildIndex(index);
            this.addToCandidateIndexes(candidateIndexes, index, minValue, false);
            return this.getIndexOfLargestNodeLessThanOrEqualToStartingFrom(maxValue, rightChildIndex, index, candidateIndexes, minValue);
        }
        this.addToCandidateIndexes(candidateIndexes, index, minValue, false);
        return index;
    }

    private void addToCandidateIndexes(Path candidateIndexes, int index, V value, boolean valueIsMaxValue) throws IOException {
        if (null != candidateIndexes) {
            try {
                int comparison = this.compare(index, value);
                if (valueIsMaxValue) {
                    if (comparison <= 0) {
                        candidateIndexes.add(index);
                    }
                } else if (comparison >= 0) {
                    candidateIndexes.add(index);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isNull(int index) throws IOException {
        if (index >= this.arrayLength) {
            return true;
        }
        if (this.nullCheckChecksValues) {
            return this.isNullNoRangeCheck(index);
        }
        return false;
    }

    protected abstract int compareValuesAt(int var1, int var2) throws IOException;

    protected abstract int compare(int var1, V var2) throws IOException;

    protected abstract boolean isNullNoRangeCheck(int var1) throws IOException;

    protected abstract V getValueAtIndex(int var1) throws IOException;

    protected abstract void setValueAtIndex(int var1, V var2) throws IOException;

    static {
        int pow = 1;
        for (int i = 0; i < NODES_OF_HEIGHT.length; ++i) {
            BTree.NODES_OF_HEIGHT[i] = pow - 1;
            pow <<= 1;
        }
    }

    private class Path {
        List<Integer> treeIndexesInRange = new ArrayList<Integer>();
        List<Integer> depthsInRange = new ArrayList<Integer>();

        public void add(int indexInTreeArray) {
            this.treeIndexesInRange.add(indexInTreeArray);
            int depth = BTree.this.getDepthOf(indexInTreeArray);
            this.depthsInRange.add(depth);
        }

        public boolean isConnected() {
            if (this.treeIndexesInRange.size() < 2) {
                return true;
            }
            int i = 0;
            int prev = this.depthsInRange.get(i++);
            while (i < this.treeIndexesInRange.size()) {
                int current;
                if ((current = this.depthsInRange.get(i++).intValue()) - prev != 1) {
                    return false;
                }
                prev = current;
            }
            return true;
        }

        public int get(int indexInVisitedNodesInRange) {
            return this.treeIndexesInRange.get(indexInVisitedNodesInRange);
        }

        public boolean contains(int treeIndex) {
            return this.treeIndexesInRange.contains(treeIndex);
        }

        public int size() {
            return this.treeIndexesInRange.size();
        }

        public String toString() {
            return "Path [treeIndexesInRange=" + this.treeIndexesInRange + "]";
        }
    }
}

