/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.bo;

import com.browseengine.bobo.geosearch.IGeoConverter;
import com.browseengine.bobo.geosearch.IGeoUtil;
import com.browseengine.bobo.geosearch.impl.GeoConverter;
import com.browseengine.bobo.geosearch.impl.GeoUtil;
import com.browseengine.bobo.geosearch.merge.IGeoMerger;
import com.browseengine.bobo.geosearch.merge.impl.BufferedGeoMerger;
import org.springframework.stereotype.Component;

@Component
public class GeoSearchConfig {
    public static final String DEFAULT_GEO_FILE_EXTENSION = "geo";
    private IGeoConverter geoConverter = new GeoConverter();
    private IGeoUtil geoUtil = new GeoUtil();
    private IGeoMerger geoMerger = new BufferedGeoMerger();
    private String geoFileExtension = "geo";
    private String[] pairedExtensionsForDelete = new String[]{"cfs"};
    public static final int DEFAULT_ID_BYTE_COUNT = 16;
    private int bytesForId = 16;
    private int maxIndexSize = Integer.MAX_VALUE;

    public void setGeoFileExtension(String fileExtension) {
        this.geoFileExtension = fileExtension;
    }

    public String getGeoFileExtension() {
        return this.geoFileExtension;
    }

    public IGeoConverter getGeoConverter() {
        return this.geoConverter;
    }

    public void setGeoConverter(IGeoConverter geoConverter) {
        this.geoConverter = geoConverter;
    }

    public void setGeoUtil(IGeoUtil geoUtil) {
        this.geoUtil = geoUtil;
    }

    public void addFieldBitMask(String fieldName, byte bitMask) {
        this.geoConverter.addFieldBitMask(fieldName, bitMask);
    }

    public IGeoUtil getGeoUtil() {
        return this.geoUtil;
    }

    public IGeoMerger getGeoMerger() {
        return this.geoMerger;
    }

    public void setGeoMerger(IGeoMerger geoMerger) {
        this.geoMerger = geoMerger;
    }

    public String getGeoFileName(String name) {
        return name + "." + this.getGeoFileExtension();
    }

    public int getBufferSizePerGeoSegmentReader() {
        return 16384;
    }

    public void setPairedExtensionPairsForDelete(String ... pairedExtensionsForDelete) {
        this.pairedExtensionsForDelete = pairedExtensionsForDelete;
    }

    public String[] getPairedExtensionsForDelete() {
        return this.pairedExtensionsForDelete;
    }

    public void setBytesForId(int bytesForId) {
        this.bytesForId = bytesForId;
    }

    public int getBytesForId() {
        return this.bytesForId;
    }

    public void setMaxIndexSize(int maxIndexSize) {
        this.maxIndexSize = maxIndexSize;
    }

    public int getMaxIndexSize() {
        return this.maxIndexSize;
    }
}

