/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.geosearch.bo;

import com.browseengine.bobo.geosearch.bo.IGeoRecord;

public class GeoRecord
implements IGeoRecord {
    public static final byte DEFAULT_FILTER_BYTE = 0;
    public final long highOrder;
    public final int lowOrder;
    public final byte filterByte;
    public static final GeoRecord MIN_VALID_GEORECORD = new GeoRecord(0L, 0, 0);
    public static final GeoRecord MAX_VALID_GEORECORD = new GeoRecord(Long.MAX_VALUE, Integer.MAX_VALUE, 0);
    private static final int MAX_DIGITS_INT = GeoRecord.ndigits(Integer.MAX_VALUE);
    private static final int MAX_DIGITS_LONG = GeoRecord.ndigits(Long.MAX_VALUE);

    public GeoRecord(long highOrder, int lowOrder, byte filterByte) {
        if (highOrder < 0L || lowOrder < 0) {
            throw new RuntimeException("GeoRecord(" + highOrder + ", " + lowOrder + ", " + filterByte + "): only supports positive highOrder and lowOrder");
        }
        this.highOrder = highOrder;
        this.lowOrder = lowOrder;
        this.filterByte = filterByte;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.filterByte;
        result = 31 * result + (int)(this.highOrder ^ this.highOrder >>> 32);
        result = 31 * result + this.lowOrder;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoRecord other = (GeoRecord)obj;
        if (this.filterByte != other.filterByte) {
            return false;
        }
        if (this.highOrder != other.highOrder) {
            return false;
        }
        return this.lowOrder == other.lowOrder;
    }

    public String toString() {
        return "GeoRecord [padded highOrder=" + GeoRecord.lpad(this.highOrder) + ", padded lowOrder=" + GeoRecord.lpad(this.lowOrder) + ", filterByte=" + this.filterByte + "]";
    }

    public static String lpad(int val) {
        return GeoRecord.lpad(MAX_DIGITS_INT, val);
    }

    public static String lpad(long val) {
        return GeoRecord.lpad(MAX_DIGITS_LONG, val);
    }

    private static String lpad(int maxDigits, long val) {
        int ndigits = GeoRecord.ndigits(val);
        StringBuilder buf = new StringBuilder();
        for (int pad = maxDigits - ndigits; pad > 0; --pad) {
            buf.append('0');
        }
        buf.append(val);
        return buf.toString();
    }

    private static int ndigits(long val) {
        int i = 0;
        for (val = Long.highestOneBit(val); val > 0L; val /= 10L) {
            ++i;
        }
        return i;
    }
}

