/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphql.spring.boot.test.GraphQLResponse;
import com.graphql.spring.boot.test.RequestFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;

public class GraphQLTestTemplate {
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private TestRestTemplate restTemplate;
    @Value(value="${graphql.servlet.mapping:/graphql}")
    private String graphqlMapping;
    private ObjectMapper objectMapper = new ObjectMapper();

    private String createJsonQuery(String graphql, ObjectNode variables) throws JsonProcessingException {
        ObjectNode wrapper = this.objectMapper.createObjectNode();
        wrapper.put("query", graphql);
        wrapper.set("variables", (JsonNode)variables);
        return this.objectMapper.writeValueAsString((Object)wrapper);
    }

    private String loadQuery(String location) throws IOException {
        Resource resource = this.resourceLoader.getResource("classpath:" + location);
        return this.loadResource(resource);
    }

    private String loadResource(Resource resource) throws IOException {
        try (InputStream inputStream = resource.getInputStream();){
            String string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public GraphQLResponse perform(String graphqlResource) throws IOException {
        return this.postForResource(graphqlResource);
    }

    public GraphQLResponse perform(String graphqlResource, ObjectNode variables) throws IOException {
        String graphql = this.loadQuery(graphqlResource);
        String payload = this.createJsonQuery(graphql, variables);
        return this.post(payload);
    }

    public GraphQLResponse postForResource(String graphqlResource) throws IOException {
        return this.perform(graphqlResource, null);
    }

    public GraphQLResponse postMultipart(String query, String variables) {
        return this.postRequest(RequestFactory.forMultipart(query, variables));
    }

    private GraphQLResponse post(String payload) {
        return this.postRequest(RequestFactory.forJson(payload));
    }

    private GraphQLResponse postRequest(HttpEntity<Object> request) {
        ResponseEntity response = this.restTemplate.exchange(this.graphqlMapping, HttpMethod.POST, request, String.class, new Object[0]);
        return new GraphQLResponse((ResponseEntity<String>)response);
    }
}

