/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheNotFoundException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class FallbackMustacheFactory
extends DefaultMustacheFactory {
    private Object[] resourceRoots;

    public FallbackMustacheFactory(String resourceRoot, String fallbackRoot) {
        this(new String[]{resourceRoot, fallbackRoot});
    }

    public FallbackMustacheFactory(File fileRoot, File fallbackRoot) {
        this(new File[]{fileRoot, fallbackRoot});
    }

    public FallbackMustacheFactory(Object ... resourceRoots) {
        for (Object resourceObj : resourceRoots) {
            if (resourceObj instanceof String) {
                String resourceRoot = (String)resourceObj;
                if (resourceRoot.endsWith("/")) continue;
                resourceRoot = resourceRoot + "/";
                continue;
            }
            if (resourceObj instanceof File) {
                File fileRoot = (File)resourceObj;
                if (!fileRoot.exists()) {
                    throw new MustacheException(fileRoot + " does not exist");
                }
                if (fileRoot.isDirectory()) continue;
                throw new MustacheException(fileRoot + " is not a directory");
            }
            if (resourceObj == null) continue;
            throw new MustacheException("Invalid constructor parameter: " + resourceObj.toString());
        }
        this.resourceRoots = resourceRoots;
    }

    @Override
    public Reader getReader(String resourceName) {
        Exception lastException = null;
        for (Object resourceObj : this.resourceRoots) {
            try {
                File file;
                InputStream is = null;
                if (resourceObj instanceof String) {
                    String resourceRoot = (String)resourceObj;
                    ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                    is = ccl.getResourceAsStream(resourceRoot + resourceName);
                }
                if (is == null && (file = resourceObj instanceof String ? new File((String)resourceObj, resourceName) : (resourceObj instanceof File ? new File((File)resourceObj, resourceName) : new File(resourceName))).exists() && file.isFile()) {
                    try {
                        is = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        throw new MustacheException("Found file, could not open: " + file, e);
                    }
                }
                if (is == null) {
                    throw new MustacheNotFoundException(resourceName);
                }
                return new BufferedReader(new InputStreamReader(is, "UTF-8"));
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        throw new MustacheNotFoundException(resourceName, lastException);
    }
}

