/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web.provider;

import com.charlyghislain.authenticator.admin.api.domain.WsError;
import com.charlyghislain.authenticator.admin.api.error.AuthenticatorAdminWebError;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class WebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    private static final Logger LOG = LoggerFactory.getLogger(WebApplicationExceptionMapper.class);

    public Response toResponse(@NonNull WebApplicationException exception) {
        LOG.warn("Uncaught exception while serving request", (Throwable)exception);
        WsError wsError = new WsError();
        wsError.setCode(AuthenticatorAdminWebError.UNEXPECTED_ERROR.name());
        return Response.status((int)exception.getResponse().getStatus()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)wsError).build();
    }
}

