/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web.provider;

import com.charlyghislain.authenticator.admin.web.provider.CorsUtils;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Provider
@Priority(value=3000)
public class CrossOriginResourceSharingResponseFilter
implements ContainerResponseFilter {
    @Inject
    private HttpServletRequest httpServletRequest;
    @Inject
    @ConfigProperty(name="com.charlyghislain.authenticator.cors.allowedOrigins")
    private List<String> corsAllowedOrigins;

    public void filter(@NonNull ContainerRequestContext requestContext, @NonNull ContainerResponseContext response) {
        String origin = requestContext.getHeaderString("Origin");
        boolean originValid = CorsUtils.isOriginValid((String)origin, (List)this.corsAllowedOrigins);
        if (originValid) {
            MultivaluedMap headerMap = response.getHeaders();
            headerMap.putSingle((Object)"Access-Control-Allow-Origin", (Object)origin);
            headerMap.putSingle((Object)"Access-Control-Allow-Credentials", (Object)"true");
        }
    }

    public void filter(@NonNull HttpServletResponse servletResponse) {
        String origin = this.httpServletRequest.getHeader("Origin");
        boolean originValid = CorsUtils.isOriginValid((String)origin, (List)this.corsAllowedOrigins);
        if (originValid) {
            servletResponse.addHeader("Access-Control-Allow-Origin", origin);
            servletResponse.addHeader("Access-Control-Allow-Credentials", "true");
        }
    }

    public void filter(@NonNull Response response) {
        String origin = this.httpServletRequest.getHeader("Origin");
        boolean originValid = CorsUtils.isOriginValid((String)origin, (List)this.corsAllowedOrigins);
        if (originValid) {
            MultivaluedMap headerMap = response.getHeaders();
            headerMap.putSingle((Object)"Access-Control-Allow-Origin", (Object)origin);
            headerMap.putSingle((Object)"Access-Control-Allow-Credentials", (Object)"true");
        }
    }
}

