/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web.provider;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class CorsUtils {
    public static final String CORS_ALLOWED_ORIGINS_WILDCARD = "*";

    public static boolean isOriginValid(String origin, @Nullable List<String> allowedOrigins) {
        if (allowedOrigins == null || allowedOrigins.isEmpty()) {
            return false;
        }
        boolean isAllowed = allowedOrigins.stream().map(allowedOrigin -> CorsUtils.isOriginAllowed((String)origin, (String)allowedOrigin)).filter(allowed -> allowed).findFirst().orElse(false);
        return isAllowed;
    }

    public static void filterCorsOptionsRequest(ContainerRequestContext requestContext, List<String> allowedOriging) {
        String method = requestContext.getMethod();
        if (!"OPTIONS".equals(method)) {
            return;
        }
        String origin = requestContext.getHeaderString("Origin");
        boolean originValid = CorsUtils.isOriginValid((String)origin, allowedOriging);
        if (originValid) {
            Response okResponse = Response.ok().header("Access-Control-Allow-Methods", (Object)"OPTIONS, GET, POST, PUT, DELETE").header("Access-Control-Allow-Headers", (Object)"content-type, accept, accept-charset, authorization, X-Requested-With").header("Access-Control-Expose-Headers", (Object)"accept-ranges, content-encoding, content-length").build();
            requestContext.abortWith(okResponse);
        }
    }

    private static boolean isOriginAllowed(@Nullable String origin, @Nullable String allowedOrigin) {
        if (allowedOrigin == null || origin == null) {
            return false;
        }
        if (allowedOrigin.equals("*")) {
            return true;
        }
        try {
            URI allowedUri = new URI(allowedOrigin);
            URI originUri = new URI(origin);
            URI relativized = allowedUri.relativize(originUri);
            return !relativized.equals(originUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

