/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web.provider;

import com.charlyghislain.authenticator.admin.api.domain.WsError;
import com.charlyghislain.authenticator.admin.api.error.AuthenticatorAdminWebException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class AuthenticatorAdminWebExceptionMapper
implements ExceptionMapper<AuthenticatorAdminWebException> {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticatorAdminWebExceptionMapper.class);

    public Response toResponse(@NonNull AuthenticatorAdminWebException exception) {
        String code = exception.getCode();
        int status = exception.getStatus();
        String description = exception.getDescription();
        if (status >= 500) {
            LOG.warn("Uncaught unexpected exception", (Throwable)exception);
        }
        WsError wsError = new WsError();
        wsError.setCode(code);
        wsError.setDescription(description);
        return Response.status((int)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)wsError).build();
    }
}

