/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web.converter;

import com.charlyghislain.authenticator.admin.api.domain.WsKey;
import com.charlyghislain.authenticator.domain.domain.Application;
import com.charlyghislain.authenticator.domain.domain.RsaKeyPair;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.checkerframework.checker.nullness.qual.NonNull;

@ApplicationScoped
public class WsKeyConverter {
    public @NonNull WsKey toWskey(@NonNull RsaKeyPair key) {
        Long id = key.getId();
        String name = key.getName();
        boolean active = key.isActive();
        Optional application = key.getApplication();
        LocalDateTime creationTime = key.getCreationTime();
        boolean forApplicationSecrets = key.isForApplicationSecrets();
        boolean signingKey = key.isSigningKey();
        Optional<Long> applicationId = application.map(Application::getId);
        Optional<ZonedDateTime> creationZonedDateTime = Optional.ofNullable(creationTime).map(t -> t.atZone(ZoneId.systemDefault()));
        WsKey wsKey = new WsKey();
        Optional.ofNullable(id).ifPresent(arg_0 -> ((WsKey)wsKey).setId(arg_0));
        wsKey.setActive(active);
        Optional.ofNullable(name).ifPresent(arg_0 -> ((WsKey)wsKey).setName(arg_0));
        applicationId.ifPresent(arg_0 -> ((WsKey)wsKey).setApplicationId(arg_0));
        creationZonedDateTime.ifPresent(arg_0 -> ((WsKey)wsKey).setCreationDateTime(arg_0));
        wsKey.setForApplicationSecrets(forApplicationSecrets);
        wsKey.setSigningKey(signingKey);
        return wsKey;
    }
}

