/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web.converter;

import com.charlyghislain.authenticator.admin.api.domain.WsApplication;
import com.charlyghislain.authenticator.domain.domain.Application;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.enterprise.context.ApplicationScoped;
import org.checkerframework.checker.nullness.qual.NonNull;

@ApplicationScoped
public class WsApplicationConverter {
    public @NonNull WsApplication toWsapplication(@NonNull Application application) {
        Long id = application.getId();
        String name = application.getName();
        boolean active = application.isActive();
        String endpointUrl = application.getEndpointUrl();
        LocalDateTime creationTime = application.getCreationTime();
        boolean canResetUserPassword = application.isCanResetUserPassword();
        boolean canVerifyUserEmail = application.isCanVerifyUserEmail();
        boolean addedUsersAreActive = application.isAddedUsersAreActive();
        boolean existingUsersAreAddedOnTokenRequest = application.isExistingUsersAreAddedOnTokenRequest();
        ZonedDateTime creationZonedDateTime = creationTime.atZone(ZoneId.systemDefault());
        WsApplication wsApplication = new WsApplication();
        wsApplication.setId(id);
        wsApplication.setActive(Boolean.valueOf(active));
        wsApplication.setName(name);
        wsApplication.setEndpointUrl(endpointUrl);
        wsApplication.setCreationDateTime(creationZonedDateTime);
        wsApplication.setCanResetUserPassword(Boolean.valueOf(canResetUserPassword));
        wsApplication.setCanVerifyUserEmail(Boolean.valueOf(canVerifyUserEmail));
        wsApplication.setAddedUsersAreActive(Boolean.valueOf(addedUsersAreActive));
        wsApplication.setExistingUsersAreAddedOnTokenRequest(Boolean.valueOf(existingUsersAreAddedOnTokenRequest));
        return wsApplication;
    }
}

