/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web.converter;

import com.charlyghislain.authenticator.admin.api.domain.WsUser;
import com.charlyghislain.authenticator.domain.domain.User;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.checkerframework.checker.nullness.qual.NonNull;

@ApplicationScoped
public class UserConverter {
    public @NonNull User toUser(@NonNull WsUser wsUser) {
        Long id = wsUser.getId();
        String name = wsUser.getName();
        String email = wsUser.getEmail();
        boolean active = wsUser.isActive();
        boolean admin = wsUser.isAdmin();
        boolean emailVerified = wsUser.isEmailVerified();
        boolean passwordExpired = wsUser.isPasswordExpired();
        ZonedDateTime creationDateTime = wsUser.getCreationDateTime();
        Optional<LocalDateTime> creationLocalDateTime = Optional.ofNullable(creationDateTime).map(z -> z.withZoneSameInstant(ZoneId.systemDefault())).map(ZonedDateTime::toLocalDateTime);
        User user = new User();
        Optional.ofNullable(id).ifPresent(arg_0 -> ((User)user).setId(arg_0));
        Optional.ofNullable(name).ifPresent(arg_0 -> ((User)user).setName(arg_0));
        Optional.ofNullable(email).ifPresent(arg_0 -> ((User)user).setEmail(arg_0));
        user.setActive(active);
        user.setAdmin(admin);
        user.setEmailVerified(emailVerified);
        user.setPasswordExpired(passwordExpired);
        creationLocalDateTime.ifPresent(arg_0 -> ((User)user).setCreationTime(arg_0));
        return user;
    }
}

