/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web.converter;

import com.charlyghislain.authenticator.admin.api.domain.WsKeyFilter;
import com.charlyghislain.authenticator.admin.api.domain.WsPagination;
import com.charlyghislain.authenticator.domain.domain.RsaKeyPair;
import com.charlyghislain.authenticator.domain.domain.filter.KeyFilter;
import com.charlyghislain.authenticator.domain.domain.util.Pagination;
import com.charlyghislain.authenticator.ejb.service.ApplicationQueryService;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@ApplicationScoped
public class KeyFilterConverter {
    @Inject
    private ApplicationQueryService applicationQueryService;

    public @NonNull KeyFilter translateWsKeyFilter(@NonNull WsKeyFilter wsKeyFilter) {
        Long id = wsKeyFilter.getId();
        Boolean active = wsKeyFilter.getActive();
        Boolean forApplicationSecrets = wsKeyFilter.getForApplicationSecrets();
        Boolean forApplication = wsKeyFilter.getForApplication();
        Long applicationId = wsKeyFilter.getApplicationId();
        String name = wsKeyFilter.getName();
        String nameContains = wsKeyFilter.getNameContains();
        Optional applicationOptional = Optional.ofNullable(applicationId).flatMap(arg_0 -> ((ApplicationQueryService)this.applicationQueryService).findApplicationById(arg_0));
        KeyFilter keyFilter = new KeyFilter();
        Optional.ofNullable(id).ifPresent(arg_0 -> ((KeyFilter)keyFilter).setId(arg_0));
        Optional.ofNullable(active).ifPresent(arg_0 -> ((KeyFilter)keyFilter).setActive(arg_0));
        Optional.ofNullable(forApplicationSecrets).ifPresent(arg_0 -> ((KeyFilter)keyFilter).setForApplicationSecrets(arg_0));
        Optional.ofNullable(forApplication).ifPresent(arg_0 -> ((KeyFilter)keyFilter).setForApplication(arg_0));
        applicationOptional.ifPresent(arg_0 -> ((KeyFilter)keyFilter).setApplication(arg_0));
        Optional.ofNullable(name).ifPresent(arg_0 -> ((KeyFilter)keyFilter).setName(arg_0));
        Optional.ofNullable(nameContains).ifPresent(arg_0 -> ((KeyFilter)keyFilter).setNameContains(arg_0));
        return keyFilter;
    }

    public @NonNull Pagination<RsaKeyPair> translateWsPagination(@NonNull WsPagination input) {
        Pagination result = new Pagination();
        result.setOffset(input.getOffset());
        result.setLength(input.getLength());
        return result;
    }
}

