/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web.converter;

import com.charlyghislain.authenticator.admin.api.domain.WsKey;
import com.charlyghislain.authenticator.domain.domain.RsaKeyPair;
import com.charlyghislain.authenticator.ejb.service.ApplicationQueryService;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@ApplicationScoped
public class KeyConverter {
    @Inject
    private ApplicationQueryService applicationQueryService;

    public @NonNull RsaKeyPair toRsaKeyPair(@NonNull WsKey wsKey) {
        Long id = wsKey.getId();
        String name = wsKey.getName();
        boolean active = wsKey.isActive();
        boolean signingKey = wsKey.isSigningKey();
        boolean forApplicationSecrets = wsKey.isForApplicationSecrets();
        ZonedDateTime creationDateTime = wsKey.getCreationDateTime();
        Long applicationId = wsKey.getApplicationId();
        Optional<LocalDateTime> creationLocalDateTimeOptional = Optional.ofNullable(creationDateTime).map(ZonedDateTime::toLocalDateTime);
        Optional applicationOptional = Optional.ofNullable(applicationId).flatMap(arg_0 -> ((ApplicationQueryService)this.applicationQueryService).findApplicationById(arg_0));
        RsaKeyPair key = new RsaKeyPair();
        Optional.ofNullable(id).ifPresent(arg_0 -> ((RsaKeyPair)key).setId(arg_0));
        Optional.ofNullable(name).ifPresent(arg_0 -> ((RsaKeyPair)key).setName(arg_0));
        key.setActive(active);
        key.setSigningKey(signingKey);
        key.setForApplicationSecrets(forApplicationSecrets);
        creationLocalDateTimeOptional.ifPresent(arg_0 -> ((RsaKeyPair)key).setCreationTime(arg_0));
        applicationOptional.ifPresent(arg_0 -> ((RsaKeyPair)key).setApplication(arg_0));
        return key;
    }
}

