/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web.converter;

import com.charlyghislain.authenticator.admin.api.domain.WsApplication;
import com.charlyghislain.authenticator.domain.domain.Application;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.checkerframework.checker.nullness.qual.NonNull;

@ApplicationScoped
public class ApplicationConverter {
    public @NonNull Application toWsApplication(@NonNull WsApplication wsApplication) {
        Long id = wsApplication.getId();
        String name = wsApplication.getName();
        String endpointUrl = wsApplication.getEndpointUrl();
        Boolean active = wsApplication.getActive();
        ZonedDateTime creationDateTime = wsApplication.getCreationDateTime();
        Boolean canResetUserPassword = wsApplication.getCanResetUserPassword();
        Boolean canVerifyUserEmail = wsApplication.getCanVerifyUserEmail();
        Boolean addedUsersAreActive = wsApplication.getAddedUsersAreActive();
        Boolean existingUsersAreAddedOnTokenRequest = wsApplication.getExistingUsersAreAddedOnTokenRequest();
        Optional<LocalDateTime> creationLocalDateTime = Optional.ofNullable(creationDateTime).map(ZonedDateTime::toLocalDateTime);
        Application application = new Application();
        Optional.ofNullable(id).ifPresent(arg_0 -> ((Application)application).setId(arg_0));
        Optional.ofNullable(name).ifPresent(arg_0 -> ((Application)application).setName(arg_0));
        Optional.ofNullable(endpointUrl).ifPresent(arg_0 -> ((Application)application).setEndpointUrl(arg_0));
        Optional.ofNullable(active).ifPresent(arg_0 -> ((Application)application).setActive(arg_0));
        creationLocalDateTime.ifPresent(arg_0 -> ((Application)application).setCreationTime(arg_0));
        Optional.ofNullable(canResetUserPassword).ifPresent(arg_0 -> ((Application)application).setCanResetUserPassword(arg_0));
        Optional.ofNullable(canVerifyUserEmail).ifPresent(arg_0 -> ((Application)application).setCanVerifyUserEmail(arg_0));
        Optional.ofNullable(addedUsersAreActive).ifPresent(arg_0 -> ((Application)application).setAddedUsersAreActive(arg_0));
        Optional.ofNullable(existingUsersAreAddedOnTokenRequest).ifPresent(arg_0 -> ((Application)application).setExistingUsersAreAddedOnTokenRequest(arg_0));
        return application;
    }
}

