/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web;

import com.charlyghislain.authenticator.admin.api.AdminUserResource;
import com.charlyghislain.authenticator.admin.api.domain.WsPagination;
import com.charlyghislain.authenticator.admin.api.domain.WsResultList;
import com.charlyghislain.authenticator.admin.api.domain.WsUser;
import com.charlyghislain.authenticator.admin.api.domain.WsUserApplication;
import com.charlyghislain.authenticator.admin.api.domain.WsUserFilter;
import com.charlyghislain.authenticator.admin.api.error.AuthenticatorAdminWebError;
import com.charlyghislain.authenticator.admin.api.error.AuthenticatorAdminWebException;
import com.charlyghislain.authenticator.admin.web.converter.UserApplicationFilterConverter;
import com.charlyghislain.authenticator.admin.web.converter.UserConverter;
import com.charlyghislain.authenticator.admin.web.converter.UserFilterConverter;
import com.charlyghislain.authenticator.admin.web.converter.WsUserApplicationConverter;
import com.charlyghislain.authenticator.admin.web.converter.WsUserConverter;
import com.charlyghislain.authenticator.domain.domain.Application;
import com.charlyghislain.authenticator.domain.domain.User;
import com.charlyghislain.authenticator.domain.domain.UserApplication;
import com.charlyghislain.authenticator.domain.domain.exception.AdminCannotLockHerselfOutException;
import com.charlyghislain.authenticator.domain.domain.exception.EmailAlreadyExistsException;
import com.charlyghislain.authenticator.domain.domain.exception.NameAlreadyExistsException;
import com.charlyghislain.authenticator.domain.domain.filter.UserApplicationFilter;
import com.charlyghislain.authenticator.domain.domain.filter.UserFilter;
import com.charlyghislain.authenticator.domain.domain.util.Pagination;
import com.charlyghislain.authenticator.domain.domain.util.ResultList;
import com.charlyghislain.authenticator.ejb.service.ApplicationQueryService;
import com.charlyghislain.authenticator.ejb.service.UserQueryService;
import com.charlyghislain.authenticator.ejb.service.UserUpdateService;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@RolesAllowed(value={"authenticator.ADMIN"})
public class AdminUserResourceController
implements AdminUserResource {
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private UserUpdateService userUpdateService;
    @Inject
    private ApplicationQueryService applicationQueryService;
    @Inject
    private WsUserConverter wsUserConverter;
    @Inject
    private WsUserApplicationConverter wsUserApplicationConverter;
    @Inject
    private UserFilterConverter userFilterConverter;
    @Inject
    private UserConverter userConverter;
    @Inject
    private UserApplicationFilterConverter userApplicationFilterConverter;

    public @NonNull WsResultList<WsUser> listUsers(WsUserFilter wsUserFilter, WsPagination wsPagination) {
        Pagination pagination = this.userFilterConverter.translateWsPagination(wsPagination);
        UserFilter userFilter = this.userFilterConverter.translateWsUserFilter(wsUserFilter);
        ResultList userResultList = this.userQueryService.findUsers(userFilter, pagination);
        List wsUserList = userResultList.map(arg_0 -> ((WsUserConverter)this.wsUserConverter).toWsuser(arg_0)).getResults();
        return new WsResultList(wsUserList, userResultList.getTotalCount());
    }

    public WsUser getUser(Long userId) {
        return this.userQueryService.findUserById(userId).map(arg_0 -> ((WsUserConverter)this.wsUserConverter).toWsuser(arg_0)).orElseThrow(() -> this.newNotFoundException());
    }

    public @NonNull WsUser createUser(WsUser wsUser) {
        User user = this.userConverter.toUser(wsUser);
        try {
            User createdUser = this.userUpdateService.createUser(user);
            return this.wsUserConverter.toWsuser(createdUser);
        }
        catch (EmailAlreadyExistsException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.EMAIL_ALREADY_EXISTS);
        }
        catch (NameAlreadyExistsException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.NAME_ALREADY_EXISTS);
        }
    }

    public @NonNull WsUser updateUser(Long userId, WsUser wsUser) {
        User user = this.userConverter.toUser(wsUser);
        user.setCreationTime(LocalDateTime.now());
        User existingUser = (User)this.userQueryService.findUserById(userId).orElseThrow(() -> this.newNotFoundException());
        try {
            User updatedUser = this.userUpdateService.updateUser(existingUser, user);
            return this.wsUserConverter.toWsuser(updatedUser);
        }
        catch (AdminCannotLockHerselfOutException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.LOCKING_ADMIN_OUT);
        }
        catch (EmailAlreadyExistsException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.EMAIL_ALREADY_EXISTS);
        }
        catch (NameAlreadyExistsException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.NAME_ALREADY_EXISTS);
        }
    }

    public void deleteUser(Long userId) {
        User existingUser = (User)this.userQueryService.findUserById(userId).orElseThrow(() -> this.newNotFoundException());
        this.userUpdateService.deleteUser(existingUser);
    }

    public void updatePassword(Long userId, @NonNull String password) {
        User existingUser = (User)this.userQueryService.findUserById(userId).orElseThrow(() -> this.newNotFoundException());
        boolean validPassword = this.userUpdateService.checkPasswordValidity(password);
        if (!validPassword) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.INVALID_PASSWORD, "com.charlyghislain.authenticator.domain.domain.validation.ValidPassword.message");
        }
        this.userUpdateService.setUserPassword(existingUser, password);
    }

    public @NonNull WsResultList<WsUserApplication> listUserApplications(Long userId, @NonNull WsPagination wsPagination) {
        this.userQueryService.findUserById(userId).orElseThrow(() -> this.newNotFoundException());
        Pagination pagination = this.userApplicationFilterConverter.toWsPagination(wsPagination);
        UserApplicationFilter userApplicationFilter = new UserApplicationFilter();
        userApplicationFilter.getUserFilter().setId(userId);
        ResultList userApplications = this.userQueryService.findUserApplications(userApplicationFilter, pagination);
        List wsUserApplications = userApplications.map(arg_0 -> ((WsUserApplicationConverter)this.wsUserApplicationConverter).toWsUserApplication(arg_0)).getResults();
        return new WsResultList(wsUserApplications, userApplications.getTotalCount());
    }

    public @NonNull WsUserApplication activateUserApplication(Long userId, Long applicationId) {
        User user = (User)this.userQueryService.findUserById(userId).orElseThrow(() -> this.newNotFoundException());
        Application application = (Application)this.applicationQueryService.findApplicationById(applicationId).orElseThrow(() -> this.newNotFoundException());
        UserApplication userApplication = (UserApplication)this.userQueryService.findUserApplication(user, application).orElseThrow(() -> this.newNotFoundException());
        UserApplication updatedUserApplication = this.userUpdateService.setUserApplicationActive(userApplication, true);
        return this.wsUserApplicationConverter.toWsUserApplication(updatedUserApplication);
    }

    public @NonNull WsUserApplication deactivateUserApplication(Long userId, Long applicationId) {
        User user = (User)this.userQueryService.findUserById(userId).orElseThrow(() -> this.newNotFoundException());
        Application application = (Application)this.applicationQueryService.findApplicationById(applicationId).orElseThrow(() -> this.newNotFoundException());
        UserApplication userApplication = (UserApplication)this.userQueryService.findUserApplication(user, application).orElseThrow(() -> this.newNotFoundException());
        UserApplication updatedUserApplication = this.userUpdateService.setUserApplicationActive(userApplication, false);
        return this.wsUserApplicationConverter.toWsUserApplication(updatedUserApplication);
    }

    private AuthenticatorAdminWebException newNotFoundException() {
        return new AuthenticatorAdminWebException(AuthenticatorAdminWebError.USER_NOT_FOUND);
    }
}

