/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web;

import com.charlyghislain.authenticator.admin.api.AdminKeyResource;
import com.charlyghislain.authenticator.admin.api.domain.WsKey;
import com.charlyghislain.authenticator.admin.api.domain.WsKeyFilter;
import com.charlyghislain.authenticator.admin.api.domain.WsPagination;
import com.charlyghislain.authenticator.admin.api.domain.WsResultList;
import com.charlyghislain.authenticator.admin.api.error.AuthenticatorAdminWebError;
import com.charlyghislain.authenticator.admin.api.error.AuthenticatorAdminWebException;
import com.charlyghislain.authenticator.admin.web.converter.KeyConverter;
import com.charlyghislain.authenticator.admin.web.converter.KeyFilterConverter;
import com.charlyghislain.authenticator.admin.web.converter.WsKeyConverter;
import com.charlyghislain.authenticator.domain.domain.RsaKeyPair;
import com.charlyghislain.authenticator.domain.domain.exception.CannotDeactivateSigningKey;
import com.charlyghislain.authenticator.domain.domain.exception.KeyIsLastActiveInScopeException;
import com.charlyghislain.authenticator.domain.domain.exception.KeyScopeChangedException;
import com.charlyghislain.authenticator.domain.domain.exception.NameAlreadyExistsException;
import com.charlyghislain.authenticator.domain.domain.filter.KeyFilter;
import com.charlyghislain.authenticator.domain.domain.util.Pagination;
import com.charlyghislain.authenticator.domain.domain.util.ResultList;
import com.charlyghislain.authenticator.ejb.service.RsaKeyPairConverterService;
import com.charlyghislain.authenticator.ejb.service.RsaKeyPairQueryService;
import com.charlyghislain.authenticator.ejb.service.RsaKeyPairUpdateService;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@RolesAllowed(value={"authenticator.ADMIN"})
public class AdminKeyResourceController
implements AdminKeyResource {
    @Inject
    private RsaKeyPairQueryService rsaKeyPairQueryService;
    @Inject
    private RsaKeyPairConverterService rsaKeyPairConverterService;
    @Inject
    private WsKeyConverter wsKeyConverter;
    @Inject
    private RsaKeyPairUpdateService rsaKeyPairUpdateService;
    @Inject
    private KeyConverter keyConverter;
    @Inject
    private KeyFilterConverter keyFilterConverter;

    public @NonNull WsResultList<WsKey> listKeys(@NonNull WsKeyFilter wsKeyFilter, WsPagination wsPagination) {
        KeyFilter keyFilter = this.keyFilterConverter.translateWsKeyFilter(wsKeyFilter);
        Pagination rsaKeyPairPagination = this.keyFilterConverter.translateWsPagination(wsPagination);
        ResultList rsaKeyPairs = this.rsaKeyPairQueryService.findRsaKeyPairs(keyFilter, rsaKeyPairPagination);
        List wsKeyList = rsaKeyPairs.map(arg_0 -> ((WsKeyConverter)this.wsKeyConverter).toWskey(arg_0)).getResults();
        return new WsResultList(wsKeyList, rsaKeyPairs.getTotalCount());
    }

    public WsKey getKey(Long keyId) {
        return this.rsaKeyPairQueryService.findRsaKeyPairById(keyId).map(arg_0 -> ((WsKeyConverter)this.wsKeyConverter).toWskey(arg_0)).orElseThrow(() -> this.newNotFoundException());
    }

    public @NonNull WsKey createKey(@NonNull WsKey wsKey) {
        RsaKeyPair key = this.keyConverter.toRsaKeyPair(wsKey);
        key.setCreationTime(LocalDateTime.now());
        try {
            RsaKeyPair rsaKeyPair = this.rsaKeyPairUpdateService.createNewKey(key);
            return this.wsKeyConverter.toWskey(rsaKeyPair);
        }
        catch (NameAlreadyExistsException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.NAME_ALREADY_EXISTS);
        }
    }

    public @NonNull WsKey updateKey(Long keyId, @NonNull WsKey wsKey) {
        RsaKeyPair keyUpdate = this.keyConverter.toRsaKeyPair(wsKey);
        RsaKeyPair key = (RsaKeyPair)this.rsaKeyPairQueryService.findRsaKeyPairById(keyId).orElseThrow(() -> this.newNotFoundException());
        try {
            RsaKeyPair updatedKey = this.rsaKeyPairUpdateService.updateKey(key, keyUpdate);
            return this.wsKeyConverter.toWskey(updatedKey);
        }
        catch (NameAlreadyExistsException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.NAME_ALREADY_EXISTS);
        }
        catch (KeyIsLastActiveInScopeException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.LAST_ACTIVE_KEY_IN_SCOPE);
        }
        catch (KeyScopeChangedException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.KEY_SCOPE_CHANGED);
        }
        catch (CannotDeactivateSigningKey cannotDeactivateSigningKey) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.SIGNING_KEY_DEACTIVATION);
        }
    }

    public @NonNull String getPublicKeyPEM(Long keyId) {
        RsaKeyPair key = (RsaKeyPair)this.rsaKeyPairQueryService.findRsaKeyPairById(keyId).orElseThrow(() -> this.newNotFoundException());
        return this.rsaKeyPairConverterService.encodePublicKeyToPem(key);
    }

    private AuthenticatorAdminWebException newNotFoundException() {
        return new AuthenticatorAdminWebException(AuthenticatorAdminWebError.KEY_NOT_FOUND);
    }
}

