/*
 * Decompiled with CFR 0.152.
 */
package com.charlyghislain.authenticator.admin.web;

import com.charlyghislain.authenticator.admin.api.AdminApplicationResource;
import com.charlyghislain.authenticator.admin.api.domain.WsApplication;
import com.charlyghislain.authenticator.admin.api.domain.WsApplicationFilter;
import com.charlyghislain.authenticator.admin.api.domain.WsApplicationHealth;
import com.charlyghislain.authenticator.admin.api.domain.WsPagination;
import com.charlyghislain.authenticator.admin.api.domain.WsResultList;
import com.charlyghislain.authenticator.admin.api.error.AuthenticatorAdminWebError;
import com.charlyghislain.authenticator.admin.api.error.AuthenticatorAdminWebException;
import com.charlyghislain.authenticator.admin.web.converter.ApplicationConverter;
import com.charlyghislain.authenticator.admin.web.converter.ApplicationFilterConverter;
import com.charlyghislain.authenticator.admin.web.converter.WsApplicationConverter;
import com.charlyghislain.authenticator.admin.web.converter.WsApplicationHealthConverter;
import com.charlyghislain.authenticator.domain.domain.Application;
import com.charlyghislain.authenticator.domain.domain.exception.ExistingActiveApplicationUsersException;
import com.charlyghislain.authenticator.domain.domain.exception.NameAlreadyExistsException;
import com.charlyghislain.authenticator.domain.domain.exception.NoSigningKeyException;
import com.charlyghislain.authenticator.domain.domain.filter.ApplicationFilter;
import com.charlyghislain.authenticator.domain.domain.secondary.ApplicationAuthenticatorAuthorizationHealth;
import com.charlyghislain.authenticator.domain.domain.secondary.ApplicationHealth;
import com.charlyghislain.authenticator.domain.domain.util.Pagination;
import com.charlyghislain.authenticator.domain.domain.util.ResultList;
import com.charlyghislain.authenticator.ejb.service.ApplicationQueryService;
import com.charlyghislain.authenticator.ejb.service.ApplicationUpdateService;
import com.charlyghislain.authenticator.ejb.service.JwtTokenService;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@RolesAllowed(value={"authenticator.ADMIN"})
public class AdminApplicationResourceController
implements AdminApplicationResource {
    @Inject
    private ApplicationQueryService applicationQueryService;
    @Inject
    private JwtTokenService tokenService;
    @Inject
    private ApplicationUpdateService applicationUpdateService;
    @Inject
    private WsApplicationHealthConverter wsApplicationHealthConverter;
    @Inject
    private WsApplicationConverter wsApplicationConverter;
    @Inject
    private ApplicationFilterConverter applicationFilterConverter;
    @Inject
    private ApplicationConverter applicationConverter;

    public @NonNull WsResultList<WsApplication> listApplications(@NonNull WsApplicationFilter wsApplicationFilter, @NonNull WsPagination wsPagination) {
        ApplicationFilter applicationFilter = this.applicationFilterConverter.toApplicationFilter(wsApplicationFilter);
        Pagination applicationPagination = this.applicationFilterConverter.toPagination(wsPagination);
        ResultList applications = this.applicationQueryService.findApplications(applicationFilter, applicationPagination);
        List wsResults = applications.map(arg_0 -> ((WsApplicationConverter)this.wsApplicationConverter).toWsapplication(arg_0)).getResults();
        return new WsResultList(wsResults, applications.getTotalCount());
    }

    public WsApplication getApplication(Long applicationId) {
        return this.applicationQueryService.findApplicationById(applicationId).map(arg_0 -> ((WsApplicationConverter)this.wsApplicationConverter).toWsapplication(arg_0)).orElseThrow(() -> this.newNotFoundException());
    }

    public @NonNull WsApplication updateApplication(Long applicationId, @NonNull WsApplication wsApplication) {
        Application application = this.applicationConverter.toWsApplication(wsApplication);
        Application existingApplication = (Application)this.applicationQueryService.findApplicationById(applicationId).orElseThrow(() -> this.newNotFoundException());
        try {
            Application updatedApplication = this.applicationUpdateService.updateApplication(existingApplication, application);
            return this.wsApplicationConverter.toWsapplication(updatedApplication);
        }
        catch (NameAlreadyExistsException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.NAME_ALREADY_EXISTS);
        }
    }

    public void deleteApplication(Long applicationId) {
        Application existingApplication = (Application)this.applicationQueryService.findApplicationById(applicationId).orElseThrow(() -> this.newNotFoundException());
        try {
            this.applicationUpdateService.removeApplication(existingApplication);
        }
        catch (ExistingActiveApplicationUsersException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.ACTIVE_USERS_EXIST);
        }
    }

    public @NonNull WsApplication createApplication(@NonNull WsApplication wsApplication) {
        Application application = this.applicationConverter.toWsApplication(wsApplication);
        application.setCreationTime(LocalDateTime.now());
        try {
            Application updatedApplication = this.applicationUpdateService.createApplication(application);
            return this.wsApplicationConverter.toWsapplication(updatedApplication);
        }
        catch (NameAlreadyExistsException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.NAME_ALREADY_EXISTS);
        }
    }

    public String createApplicationToken(Long applicationId) {
        Application application = (Application)this.applicationQueryService.findApplicationById(applicationId).orElseThrow(() -> this.newNotFoundException());
        try {
            return this.tokenService.generateApplicationTokenForAuthenticator(application);
        }
        catch (NoSigningKeyException e) {
            throw new AuthenticatorAdminWebException(AuthenticatorAdminWebError.NO_SIGNING_KEY);
        }
    }

    public @NonNull WsApplicationHealth getApplicationHealth(Long applicationId) {
        Application application = (Application)this.applicationQueryService.findApplicationById(applicationId).orElseThrow(() -> this.newNotFoundException());
        ApplicationAuthenticatorAuthorizationHealth providerAuthorizationHealth = this.applicationQueryService.checkProviderAuthorizationHealth(application);
        ApplicationHealth applicationHealth = this.applicationQueryService.checkApplicationHealth(application);
        return this.wsApplicationHealthConverter.toWsApplicationHealth(applicationHealth, providerAuthorizationHealth);
    }

    private AuthenticatorAdminWebException newNotFoundException() {
        return new AuthenticatorAdminWebException(AuthenticatorAdminWebError.APPLICAITON_NOT_FOUND);
    }
}

