/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.Converter;
import com.cedarsoftware.util.ReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;

public class DeepEquals {
    public static final String IGNORE_CUSTOM_EQUALS = "ignoreCustomEquals";
    public static final String ALLOW_STRINGS_TO_MATCH_NUMBERS = "stringsCanMatchNumbers";
    private static final Map<String, Boolean> _customEquals = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> _customHash = new ConcurrentHashMap<String, Boolean>();
    private static final double doubleEplison = 1.0E-15;
    private static final double floatEplison = 1.0E-6;
    private static final Set<Class> prims = new HashSet<Class>();

    private DeepEquals() {
    }

    public static boolean deepEquals(Object a, Object b) {
        return DeepEquals.deepEquals(a, b, new HashMap());
    }

    public static boolean deepEquals(Object a, Object b, Map<?, ?> options) {
        HashSet<ItemsToCompare> visited = new HashSet<ItemsToCompare>();
        return DeepEquals.deepEquals(a, b, options, visited);
    }

    private static boolean deepEquals(Object a, Object b, Map<?, ?> options, Set<ItemsToCompare> visited) {
        LinkedList<ItemsToCompare> stack = new LinkedList<ItemsToCompare>();
        Set ignoreCustomEquals = (Set)options.get(IGNORE_CUSTOM_EQUALS);
        boolean allowStringsToMatchNumbers = Converter.convert2boolean(options.get(ALLOW_STRINGS_TO_MATCH_NUMBERS));
        stack.addFirst(new ItemsToCompare(a, b));
        while (!stack.isEmpty()) {
            Object key2;
            ItemsToCompare itemsToCompare = (ItemsToCompare)stack.removeFirst();
            visited.add(itemsToCompare);
            Object key1 = itemsToCompare._key1;
            if (key1 == (key2 = itemsToCompare._key2)) continue;
            if (key1 == null || key2 == null) {
                return false;
            }
            if (key1 instanceof Number && key2 instanceof Number && DeepEquals.compareNumbers((Number)key1, (Number)key2)) continue;
            if (key1 instanceof Number || key2 instanceof Number) {
                if (allowStringsToMatchNumbers) {
                    try {
                        if (key1 instanceof String && DeepEquals.compareNumbers(Converter.convert2BigDecimal(key1), (Number)key2) || key2 instanceof String && DeepEquals.compareNumbers((Number)key1, Converter.convert2BigDecimal(key2))) {
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
            Class<?> key1Class = key1.getClass();
            if (key1Class.isPrimitive() || prims.contains(key1Class) || key1 instanceof String || key1 instanceof Date || key1 instanceof Class) {
                if (key1.equals(key2)) continue;
                return false;
            }
            if (key1 instanceof Collection ? !(key2 instanceof Collection) : key2 instanceof Collection) {
                return false;
            }
            if (key1 instanceof SortedSet ? !(key2 instanceof SortedSet) : key2 instanceof SortedSet) {
                return false;
            }
            if (key1 instanceof SortedMap ? !(key2 instanceof SortedMap) : key2 instanceof SortedMap) {
                return false;
            }
            if (key1 instanceof Map ? !(key2 instanceof Map) : key2 instanceof Map) {
                return false;
            }
            if (!(DeepEquals.isContainerType(key1) || DeepEquals.isContainerType(key2) || key1Class.equals(key2.getClass()))) {
                return false;
            }
            if (key1Class.isArray()) {
                if (DeepEquals.compareArrays(key1, key2, stack, visited)) continue;
                return false;
            }
            if (key1 instanceof SortedSet) {
                if (DeepEquals.compareOrderedCollection((Collection)key1, (Collection)key2, stack, visited)) continue;
                return false;
            }
            if (key1 instanceof Set) {
                if (DeepEquals.compareUnorderedCollection((Collection)key1, (Collection)key2, stack, visited, options)) continue;
                return false;
            }
            if (key1 instanceof Collection) {
                if (DeepEquals.compareOrderedCollection((Collection)key1, (Collection)key2, stack, visited)) continue;
                return false;
            }
            if (key1 instanceof SortedMap) {
                if (DeepEquals.compareSortedMap((SortedMap)key1, (SortedMap)key2, stack, visited)) continue;
                return false;
            }
            if (key1 instanceof Map) {
                if (DeepEquals.compareUnorderedMap((Map)key1, (Map)key2, stack, visited, options)) continue;
                return false;
            }
            if (DeepEquals.hasCustomEquals(key1Class) && (ignoreCustomEquals == null || ignoreCustomEquals.size() > 0 && !ignoreCustomEquals.contains(key1Class))) {
                if (key1.equals(key2)) continue;
                return false;
            }
            Collection<Field> fields = ReflectionUtils.getDeepDeclaredFields(key1Class);
            for (Field field : fields) {
                try {
                    ItemsToCompare dk = new ItemsToCompare(field.get(key1), field.get(key2));
                    if (visited.contains(dk)) continue;
                    stack.addFirst(dk);
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public static boolean isContainerType(Object o) {
        return o instanceof Collection || o instanceof Map;
    }

    private static boolean compareArrays(Object array1, Object array2, Deque stack, Set visited) {
        int len = Array.getLength(array1);
        if (len != Array.getLength(array2)) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            ItemsToCompare dk = new ItemsToCompare(Array.get(array1, i), Array.get(array2, i));
            if (visited.contains(dk)) continue;
            stack.addFirst(dk);
        }
        return true;
    }

    private static boolean compareOrderedCollection(Collection col1, Collection col2, Deque stack, Set visited) {
        if (col1.size() != col2.size()) {
            return false;
        }
        Iterator i1 = col1.iterator();
        Iterator i2 = col2.iterator();
        while (i1.hasNext()) {
            ItemsToCompare dk = new ItemsToCompare(i1.next(), i2.next());
            if (visited.contains(dk)) continue;
            stack.addFirst(dk);
        }
        return true;
    }

    private static boolean compareUnorderedCollection(Collection col1, Collection col2, Deque stack, Set visited, Map options) {
        if (col1.size() != col2.size()) {
            return false;
        }
        HashMap fastLookup = new HashMap();
        for (Object o : col2) {
            int hash = DeepEquals.deepHashCode(o);
            ArrayList items = (ArrayList)fastLookup.get(hash);
            if (items == null) {
                items = new ArrayList();
                fastLookup.put(hash, items);
            }
            items.add(o);
        }
        for (Object o : col1) {
            Collection other = (Collection)fastLookup.get(DeepEquals.deepHashCode(o));
            if (other == null || other.isEmpty()) {
                return false;
            }
            if (other.size() == 1) {
                ItemsToCompare dk = new ItemsToCompare(o, other.iterator().next());
                if (visited.contains(dk)) continue;
                stack.addFirst(dk);
                continue;
            }
            if (DeepEquals.isContained(o, other, visited, options)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareSortedMap(SortedMap map1, SortedMap map2, Deque stack, Set visited) {
        if (map1.size() != map2.size()) {
            return false;
        }
        Iterator i1 = map1.entrySet().iterator();
        Iterator i2 = map2.entrySet().iterator();
        while (i1.hasNext()) {
            Map.Entry entry1 = i1.next();
            Map.Entry entry2 = i2.next();
            ItemsToCompare dk = new ItemsToCompare(entry1.getKey(), entry2.getKey());
            if (!visited.contains(dk)) {
                stack.addFirst(dk);
            }
            if (visited.contains(dk = new ItemsToCompare(entry1.getValue(), entry2.getValue()))) continue;
            stack.addFirst(dk);
        }
        return true;
    }

    private static boolean compareUnorderedMap(Map map1, Map map2, Deque stack, Set visited, Map options) {
        if (map1.size() != map2.size()) {
            return false;
        }
        HashMap fastLookup = new HashMap();
        for (Map.Entry entry : map2.entrySet()) {
            int hash = DeepEquals.deepHashCode(entry.getKey());
            ArrayList items = (ArrayList)fastLookup.get(hash);
            if (items == null) {
                items = new ArrayList();
                fastLookup.put(hash, items);
            }
            items.add(new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry entry : map1.entrySet()) {
            Collection other = (Collection)fastLookup.get(DeepEquals.deepHashCode(entry.getKey()));
            if (other == null || other.isEmpty()) {
                return false;
            }
            if (other.size() == 1) {
                Map.Entry entry2 = (Map.Entry)other.iterator().next();
                ItemsToCompare dk = new ItemsToCompare(entry.getKey(), entry2.getKey());
                if (!visited.contains(dk)) {
                    stack.addFirst(dk);
                }
                if (visited.contains(dk = new ItemsToCompare(entry.getValue(), entry2.getValue()))) continue;
                stack.addFirst(dk);
                continue;
            }
            if (DeepEquals.isContained(new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue()), other, visited, options)) continue;
            return false;
        }
        return true;
    }

    private static boolean isContained(Object o, Collection other, Set visited, Map options) {
        Iterator i = other.iterator();
        while (i.hasNext()) {
            Object x = i.next();
            HashSet<ItemsToCompare> visitedForSubelements = new HashSet<ItemsToCompare>(visited);
            visitedForSubelements.add(new ItemsToCompare(o, x));
            if (!DeepEquals.deepEquals(o, x, options, visitedForSubelements)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    private static boolean compareNumbers(Number a, Number b) {
        if (a instanceof Float && (b instanceof Float || b instanceof Double)) {
            return DeepEquals.compareFloatingPointNumbers(a, b, 1.0E-6);
        }
        if (a instanceof Double && (b instanceof Float || b instanceof Double)) {
            return DeepEquals.compareFloatingPointNumbers(a, b, 1.0E-15);
        }
        try {
            BigDecimal x = Converter.convert2BigDecimal(a);
            BigDecimal y = Converter.convert2BigDecimal(b);
            return (double)x.compareTo(y) == 0.0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean compareFloatingPointNumbers(Object a, Object b, double epsilon) {
        double a1 = a instanceof Double ? (Double)a : (double)((Float)a).floatValue();
        double b1 = b instanceof Double ? (Double)b : (double)((Float)b).floatValue();
        return DeepEquals.nearlyEqual(a1, b1, epsilon);
    }

    private static boolean nearlyEqual(double a, double b, double epsilon) {
        double absA = Math.abs(a);
        double absB = Math.abs(b);
        double diff = Math.abs(a - b);
        if (a == b) {
            return true;
        }
        if (a == 0.0 || b == 0.0 || diff < Double.MIN_NORMAL) {
            return diff < epsilon * Double.MIN_NORMAL;
        }
        return diff / (absA + absB) < epsilon;
    }

    public static boolean hasCustomEquals(Class<?> c) {
        StringBuilder sb = new StringBuilder(ReflectionUtils.getClassLoaderName(c));
        sb.append('.');
        sb.append(c.getName());
        String key = sb.toString();
        Boolean ret = _customEquals.get(key);
        if (ret != null) {
            return ret;
        }
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("equals", Object.class);
                _customEquals.put(key, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        _customEquals.put(key, false);
        return false;
    }

    public static int deepHashCode(Object obj) {
        HashSet<Object> visited = new HashSet<Object>();
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addFirst(obj);
        int hash = 0;
        while (!stack.isEmpty()) {
            obj = stack.removeFirst();
            if (obj == null || visited.contains(obj)) continue;
            visited.add(obj);
            if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    stack.addFirst(Array.get(obj, i));
                }
                continue;
            }
            if (obj instanceof Collection) {
                stack.addAll(0, (Collection)obj);
                continue;
            }
            if (obj instanceof Map) {
                stack.addAll(0, ((Map)obj).keySet());
                stack.addAll(0, ((Map)obj).values());
                continue;
            }
            if (obj instanceof Double || obj instanceof Float) {
                stack.add(Math.round(((Number)obj).doubleValue()));
                continue;
            }
            if (DeepEquals.hasCustomHashCode(obj.getClass())) {
                hash += obj.hashCode();
                continue;
            }
            Collection<Field> fields = ReflectionUtils.getDeepDeclaredFields(obj.getClass());
            for (Field field : fields) {
                try {
                    stack.addFirst(field.get(obj));
                }
                catch (Exception exception) {}
            }
        }
        return hash;
    }

    public static boolean hasCustomHashCode(Class<?> c) {
        StringBuilder sb = new StringBuilder(ReflectionUtils.getClassLoaderName(c));
        sb.append('.');
        sb.append(c.getName());
        String key = sb.toString();
        Boolean ret = _customHash.get(key);
        if (ret != null) {
            return ret;
        }
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("hashCode", new Class[0]);
                _customHash.put(key, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        _customHash.put(key, false);
        return false;
    }

    static {
        prims.add(Byte.class);
        prims.add(Integer.class);
        prims.add(Long.class);
        prims.add(Double.class);
        prims.add(Character.class);
        prims.add(Float.class);
        prims.add(Boolean.class);
        prims.add(Short.class);
    }

    private static final class ItemsToCompare {
        private final Object _key1;
        private final Object _key2;

        private ItemsToCompare(Object k1, Object k2) {
            this._key1 = k1;
            this._key2 = k2;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ItemsToCompare)) {
                return false;
            }
            ItemsToCompare that = (ItemsToCompare)other;
            return this._key1 == that._key1 && this._key2 == that._key2;
        }

        public int hashCode() {
            int h1 = this._key1 != null ? this._key1.hashCode() : 0;
            int h2 = this._key2 != null ? this._key2.hashCode() : 0;
            return h1 + h2;
        }
    }
}

