/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialUnavailableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ChainedTokenCredential
implements TokenCredential {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final List<TokenCredential> credentials;
    private final String unavailableError = this.getClass().getSimpleName() + " authentication failed. ---> ";

    ChainedTokenCredential(List<TokenCredential> credentials) {
        this.credentials = Collections.unmodifiableList(credentials);
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        ArrayList exceptions = new ArrayList(4);
        return Flux.fromIterable(this.credentials).flatMap(p -> p.getToken(request).doOnNext(t -> this.logger.info("Azure Identity => Attempted credential {} returns a token", new Object[]{p.getClass().getSimpleName()})).onErrorResume(Exception.class, t -> {
            if (!t.getClass().getSimpleName().equals("CredentialUnavailableException")) {
                return Mono.error((Throwable)new ClientAuthenticationException(this.unavailableError + p.getClass().getSimpleName() + " authentication failed. Error Details: " + t.getMessage(), null, (Throwable)t));
            }
            exceptions.add((CredentialUnavailableException)((Object)((Object)((Object)t))));
            this.logger.info("Azure Identity => Attempted credential {} is unavailable.", new Object[]{p.getClass().getSimpleName()});
            return Mono.empty();
        }), 1).next().switchIfEmpty(Mono.defer(() -> {
            CredentialUnavailableException last = (CredentialUnavailableException)((Object)((Object)exceptions.get(exceptions.size() - 1)));
            for (int z = exceptions.size() - 2; z >= 0; --z) {
                CredentialUnavailableException current = (CredentialUnavailableException)((Object)((Object)exceptions.get(z)));
                last = new CredentialUnavailableException(current.getMessage() + "\r\n" + last.getMessage(), last.getCause());
            }
            return Mono.error((Throwable)((Object)last));
        }));
    }
}

