/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointsmsvoice.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpointsmsvoice.model.CloudWatchLogsDestination;
import com.amazonaws.services.pinpointsmsvoice.model.EventType;
import com.amazonaws.services.pinpointsmsvoice.model.KinesisFirehoseDestination;
import com.amazonaws.services.pinpointsmsvoice.model.SnsDestination;
import com.amazonaws.services.pinpointsmsvoice.model.transform.EventDestinationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EventDestination
implements Serializable,
Cloneable,
StructuredPojo {
    private CloudWatchLogsDestination cloudWatchLogsDestination;
    private Boolean enabled;
    private KinesisFirehoseDestination kinesisFirehoseDestination;
    private List<String> matchingEventTypes;
    private String name;
    private SnsDestination snsDestination;

    public void setCloudWatchLogsDestination(CloudWatchLogsDestination cloudWatchLogsDestination) {
        this.cloudWatchLogsDestination = cloudWatchLogsDestination;
    }

    public CloudWatchLogsDestination getCloudWatchLogsDestination() {
        return this.cloudWatchLogsDestination;
    }

    public EventDestination withCloudWatchLogsDestination(CloudWatchLogsDestination cloudWatchLogsDestination) {
        this.setCloudWatchLogsDestination(cloudWatchLogsDestination);
        return this;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public EventDestination withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setKinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
        this.kinesisFirehoseDestination = kinesisFirehoseDestination;
    }

    public KinesisFirehoseDestination getKinesisFirehoseDestination() {
        return this.kinesisFirehoseDestination;
    }

    public EventDestination withKinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
        this.setKinesisFirehoseDestination(kinesisFirehoseDestination);
        return this;
    }

    public List<String> getMatchingEventTypes() {
        return this.matchingEventTypes;
    }

    public void setMatchingEventTypes(Collection<String> matchingEventTypes) {
        if (matchingEventTypes == null) {
            this.matchingEventTypes = null;
            return;
        }
        this.matchingEventTypes = new ArrayList<String>(matchingEventTypes);
    }

    public EventDestination withMatchingEventTypes(String ... matchingEventTypes) {
        if (this.matchingEventTypes == null) {
            this.setMatchingEventTypes(new ArrayList<String>(matchingEventTypes.length));
        }
        for (String ele : matchingEventTypes) {
            this.matchingEventTypes.add(ele);
        }
        return this;
    }

    public EventDestination withMatchingEventTypes(Collection<String> matchingEventTypes) {
        this.setMatchingEventTypes(matchingEventTypes);
        return this;
    }

    public EventDestination withMatchingEventTypes(EventType ... matchingEventTypes) {
        ArrayList<String> matchingEventTypesCopy = new ArrayList<String>(matchingEventTypes.length);
        for (EventType value : matchingEventTypes) {
            matchingEventTypesCopy.add(value.toString());
        }
        if (this.getMatchingEventTypes() == null) {
            this.setMatchingEventTypes(matchingEventTypesCopy);
        } else {
            this.getMatchingEventTypes().addAll(matchingEventTypesCopy);
        }
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public EventDestination withName(String name) {
        this.setName(name);
        return this;
    }

    public void setSnsDestination(SnsDestination snsDestination) {
        this.snsDestination = snsDestination;
    }

    public SnsDestination getSnsDestination() {
        return this.snsDestination;
    }

    public EventDestination withSnsDestination(SnsDestination snsDestination) {
        this.setSnsDestination(snsDestination);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCloudWatchLogsDestination() != null) {
            sb.append("CloudWatchLogsDestination: ").append(this.getCloudWatchLogsDestination()).append(",");
        }
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getKinesisFirehoseDestination() != null) {
            sb.append("KinesisFirehoseDestination: ").append(this.getKinesisFirehoseDestination()).append(",");
        }
        if (this.getMatchingEventTypes() != null) {
            sb.append("MatchingEventTypes: ").append(this.getMatchingEventTypes()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSnsDestination() != null) {
            sb.append("SnsDestination: ").append(this.getSnsDestination());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDestination)) {
            return false;
        }
        EventDestination other = (EventDestination)obj;
        if (other.getCloudWatchLogsDestination() == null ^ this.getCloudWatchLogsDestination() == null) {
            return false;
        }
        if (other.getCloudWatchLogsDestination() != null && !other.getCloudWatchLogsDestination().equals(this.getCloudWatchLogsDestination())) {
            return false;
        }
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getKinesisFirehoseDestination() == null ^ this.getKinesisFirehoseDestination() == null) {
            return false;
        }
        if (other.getKinesisFirehoseDestination() != null && !other.getKinesisFirehoseDestination().equals(this.getKinesisFirehoseDestination())) {
            return false;
        }
        if (other.getMatchingEventTypes() == null ^ this.getMatchingEventTypes() == null) {
            return false;
        }
        if (other.getMatchingEventTypes() != null && !other.getMatchingEventTypes().equals(this.getMatchingEventTypes())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSnsDestination() == null ^ this.getSnsDestination() == null) {
            return false;
        }
        return other.getSnsDestination() == null || other.getSnsDestination().equals(this.getSnsDestination());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCloudWatchLogsDestination() == null ? 0 : this.getCloudWatchLogsDestination().hashCode());
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getKinesisFirehoseDestination() == null ? 0 : this.getKinesisFirehoseDestination().hashCode());
        hashCode = 31 * hashCode + (this.getMatchingEventTypes() == null ? 0 : this.getMatchingEventTypes().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSnsDestination() == null ? 0 : this.getSnsDestination().hashCode());
        return hashCode;
    }

    public EventDestination clone() {
        try {
            return (EventDestination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventDestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

