/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalizeevents.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.personalizeevents.model.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutItemsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String datasetArn;
    private List<Item> items;

    public void setDatasetArn(String datasetArn) {
        this.datasetArn = datasetArn;
    }

    public String getDatasetArn() {
        return this.datasetArn;
    }

    public PutItemsRequest withDatasetArn(String datasetArn) {
        this.setDatasetArn(datasetArn);
        return this;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(Collection<Item> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new ArrayList<Item>(items);
    }

    public PutItemsRequest withItems(Item ... items) {
        if (this.items == null) {
            this.setItems(new ArrayList<Item>(items.length));
        }
        for (Item ele : items) {
            this.items.add(ele);
        }
        return this;
    }

    public PutItemsRequest withItems(Collection<Item> items) {
        this.setItems(items);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatasetArn() != null) {
            sb.append("DatasetArn: ").append(this.getDatasetArn()).append(",");
        }
        if (this.getItems() != null) {
            sb.append("Items: ").append(this.getItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutItemsRequest)) {
            return false;
        }
        PutItemsRequest other = (PutItemsRequest)obj;
        if (other.getDatasetArn() == null ^ this.getDatasetArn() == null) {
            return false;
        }
        if (other.getDatasetArn() != null && !other.getDatasetArn().equals(this.getDatasetArn())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || other.getItems().equals(this.getItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatasetArn() == null ? 0 : this.getDatasetArn().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        return hashCode;
    }

    public PutItemsRequest clone() {
        return (PutItemsRequest)super.clone();
    }
}

